<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="theme-color" content="#e91e63">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="format-detection" content="telephone=no">
    <title>Queen Florist - Temukan Bunga Terindah untuk Setiap Momen</title>
    <meta name="description" content="Queen Florist - Toko bunga terpercaya di Kebumen. Menyediakan berbagai jenis karangan bunga untuk semua momen spesial Anda.">
    <meta name="keywords" content="florist, toko bunga, karangan bunga, bouquet, standing flower, wedding decoration, Kebumen">
    
    <!-- Open Graph Meta Tags -->
    <meta property="og:title" content="Queen Florist - Temukan Bunga Terindah untuk Setiap Momen">
    <meta property="og:description" content="Toko bunga terpercaya di Kebumen dengan berbagai pilihan karangan bunga untuk semua momen spesial">
    <meta property="og:type" content="website">
    <meta property="og:url" content="">
    
    <!-- CSS -->
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/favicon.ico">
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar" id="navbar">
        <div class="nav-container">
            <div class="nav-logo">
                <i class="fas fa-crown"></i>
                <span>QUEEN Florist</span>
            </div>
            <ul class="nav-menu">
                <li class="nav-item">
                    <a href="#beranda" class="nav-link">Beranda</a>
                </li>
                <li class="nav-item">
                    <a href="#produk" class="nav-link">Produk</a>
                </li>
                <li class="nav-item">
                    <a href="#kontak" class="nav-link">Kontak</a>
                </li>
            </ul>
            <div class="hamburger">
                <span class="bar"></span>
                <span class="bar"></span>
                <span class="bar"></span>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section id="beranda" class="hero">
        <div class="hero-overlay"></div>
        <div class="hero-content">
            <h1 class="hero-title">Temukan Bunga Terindah untuk Setiap Momen</h1>
            <p class="hero-subtitle">Karangan bunga segar dan berkualitas untuk semua kebutuhan spesial Anda</p>
            <div class="hero-buttons">
                <a href="#produk" class="btn btn-primary">
                    <i class="fas fa-shopping-bag"></i>
                    Lihat Produk
                </a>
                <a href="https://wa.me/6281223968122?text=Hai%20kak%20mimin%20yang%20baik%20hati,%20bisa%20diinfokan..." 
                   class="btn btn-whatsapp" target="_blank">
                    <i class="fab fa-whatsapp"></i>
                    Chat Admin
                </a>
            </div>
        </div>
    </section>

    <!-- Produk Section -->
    <section id="produk" class="produk">
        <div class="container">
            <h2 class="section-title">Kategori Produk</h2>
            <p class="section-subtitle">Pilih berbagai jenis karangan bunga sesuai kebutuhan Anda</p>
            
            <!-- Kategori Buttons -->
            <div class="kategori-grid">
                <button class="kategori-btn" data-kategori="standing-flower">
                    <div class="kategori-icon">
                        <i class="fas fa-seedling"></i>
                    </div>
                    <span>Standing Flower</span>
                </button>
                
                <button class="kategori-btn" data-kategori="paper-flower">
                    <div class="kategori-icon">
                        <i class="fas fa-leaf"></i>
                    </div>
                    <span>Paper Flower</span>
                </button>
                
                <button class="kategori-btn" data-kategori="duka-cita">
                    <div class="kategori-icon">
                        <i class="fas fa-dove"></i>
                    </div>
                    <span>Duka Cita</span>
                </button>
                
                <button class="kategori-btn" data-kategori="bouquet">
                    <div class="kategori-icon">
                        <i class="fas fa-spa"></i>
                    </div>
                    <span>Bouquet</span>
                </button>
                
                <button class="kategori-btn" data-kategori="wedding-car">
                    <div class="kategori-icon">
                        <i class="fas fa-car"></i>
                    </div>
                    <span>Wedding Car</span>
                </button>
                
                <button class="kategori-btn" data-kategori="balloon-decoration">
                    <div class="kategori-icon">
                        <i class="fas fa-gift"></i>
                    </div>
                    <span>Balloon Decoration</span>
                </button>
                
                <button class="kategori-btn" data-kategori="kado-rustic">
                    <div class="kategori-icon">
                        <i class="fas fa-box"></i>
                    </div>
                    <span>Kado Rustic</span>
                </button>
                
                <button class="kategori-btn" data-kategori="balloon-parcel">
                    <div class="kategori-icon">
                        <i class="fas fa-cube"></i>
                    </div>
                    <span>Balloon Parcel</span>
                </button>
                
                <button class="kategori-btn" data-kategori="snack-bouquet">
                    <div class="kategori-icon">
                        <i class="fas fa-cookie"></i>
                    </div>
                    <span>Snack Bouquet</span>
                </button>
                
                <button class="kategori-btn" data-kategori="tart-snack">
                    <div class="kategori-icon">
                        <i class="fas fa-birthday-cake"></i>
                    </div>
                    <span>Tart Snack</span>
                </button>
            </div>

            <!-- Produk Grid -->
            <div id="produk-grid" class="produk-grid">
                <!-- Produk akan dimuat di sini via JavaScript -->
            </div>
        </div>
    </section>

    <!-- Testimoni Section -->
    <section class="testimoni">
        <div class="container">
            <h2 class="section-title">Testimoni Pelanggan</h2>
            <div class="testimoni-grid">
                <div class="testimoni-card">
                    <div class="testimoni-stars">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <p class="testimoni-text">"Bunga yang sangat segar dan cantik! Pelayanan ramah dan pengiriman tepat waktu. Sangat recommended!"</p>
                    <div class="testimoni-author">
                        <div class="author-avatar">
                            <i class="fas fa-user"></i>
                        </div>
                        <div class="author-info">
                            <h4>Siti Nurhaliza</h4>
                            <span>Pelanggan Setia</span>
                        </div>
                    </div>
                </div>
                
                <div class="testimoni-card">
                    <div class="testimoni-stars">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <p class="testimoni-text">"Queen Florist selalu menjadi pilihan utama untuk semua kebutuhan bunga saya. Kualitas terjamin!"</p>
                    <div class="testimoni-author">
                        <div class="author-avatar">
                            <i class="fas fa-user"></i>
                        </div>
                        <div class="author-info">
                            <h4>Budi Santoso</h4>
                            <span>Pelanggan Corporate</span>
                        </div>
                    </div>
                </div>
                
                <div class="testimoni-card">
                    <div class="testimoni-stars">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <p class="testimoni-text">"Hasil karangan bunga sangat rapi dan sesuai dengan permintaan. Harga terjangkau dengan kualitas premium."</p>
                    <div class="testimoni-author">
                        <div class="author-avatar">
                            <i class="fas fa-user"></i>
                        </div>
                        <div class="author-info">
                            <h4>Dewi Lestari</h4>
                            <span>Pelanggan Wedding</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Kontak Section -->
    <section id="kontak" class="kontak">
        <div class="container">
            <h2 class="section-title">Hubungi Kami</h2>
            <div class="kontak-grid">
                <div class="kontak-info">
                    <div class="kontak-item">
                        <i class="fas fa-map-marker-alt"></i>
                        <div>
                            <h4>Alamat</h4>
                            <p>Gg. Kutilang No.7, RT.03/RW.03, Panjer, Kecamatan Kebumen, Kabupaten Kebumen, Jawa Tengah 54312</p>
                        </div>
                    </div>
                    
                    <div class="kontak-item">
                        <i class="fas fa-phone"></i>
                        <div>
                            <h4>Telepon</h4>
                            <p><a href="tel:+6281223968122">+6281223968122</a></p>
                        </div>
                    </div>
                    
                    <div class="kontak-item">
                        <i class="fab fa-whatsapp"></i>
                        <div>
                            <h4>WhatsApp</h4>
                            <p><a href="https://wa.me/6281223968122" target="_blank">+6281223968122</a></p>
                        </div>
                    </div>
                    
                    <div class="social-links">
                        <h4>Ikuti Kami</h4>
                        <div class="social-icons">
                            <a href="https://www.instagram.com/queen_florist.kebumen/" target="_blank" class="social-icon">
                                <i class="fab fa-instagram"></i>
                            </a>
                            <a href="https://www.tiktok.com/@queenflorist" target="_blank" class="social-icon">
                                <i class="fab fa-tiktok"></i>
                            </a>
                        </div>
                    </div>
                </div>
                
                <div class="kontak-map">
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!4v1762247632170!6m8!1m7!1skpG8cFJKBO0zdLaW5CZAyw!2m2!1d-7.680349976965305!2d109.6613914856308!3f303.23316480780153!4f-2.325023359243332!5f0.7820865974627469" 
                        width="100%" 
                        height="450" 
                        style="border:0;" 
                        allowfullscreen="" 
                        loading="lazy" 
                        referrerpolicy="no-referrer-when-downgrade">
                    </iframe>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="footer-content">
                <div class="footer-logo">
                    <i class="fas fa-crown"></i>
                    <span>QUEEN Florist</span>
                </div>
                <p class="footer-description">Toko bunga terpercaya di Kebumen dengan kualitas terbaik dan pelayanan prima.</p>
                <div class="footer-social">
                    <a href="https://www.instagram.com/queen_florist.kebumen/" target="_blank">
                        <i class="fab fa-instagram"></i>
                    </a>
                    <a href="https://www.tiktok.com/@queenflorist" target="_blank">
                        <i class="fab fa-tiktok"></i>
                    </a>
                    <a href="https://wa.me/6281223968122" target="_blank">
                        <i class="fab fa-whatsapp"></i>
                    </a>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; 2025 Queen Florist | brainmultimedia All rights reserved.</p>
            </div>
        </div>
    </footer>

    <!-- Order Modal -->
    <div id="orderModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3>Form Pemesanan</h3>
                <span class="close">&times;</span>
            </div>
            <div class="modal-body">
                <div class="produk-preview">
                    <img id="modalProdukImage" src="" alt="Produk">
                    <h4 id="modalProdukName"></h4>
                </div>
                
                <form id="orderForm">
                    <div class="form-group">
                        <label for="nama">Nama Lengkap *</label>
                        <input type="text" id="nama" name="nama" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="catatan">Catatan Pesanan</label>
                        <textarea id="catatan" name="catatan" rows="3"></textarea>
                    </div>
                    
                    <div class="form-group">
                        <label>Rencana Ambil/Kirim *</label>
                        <div class="radio-group">
                            <label class="radio-label">
                                <input type="radio" name="pengiriman" value="ambil" checked>
                                <span>Ambil Sendiri</span>
                            </label>
                            <label class="radio-label">
                                <input type="radio" name="pengiriman" value="kirim">
                                <span>Kirim ke Alamat</span>
                            </label>
                        </div>
                    </div>
                    
                    <div class="form-group" id="alamatGroup" style="display: none;">
                        <label for="alamat">Alamat Kirim *</label>
                        <textarea id="alamat" name="alamat" rows="3"></textarea>
                    </div>
                    
                    <button type="submit" class="btn btn-whatsapp btn-block">
                        <i class="fab fa-whatsapp"></i>
                        Order Sekarang
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- JavaScript -->
    <script src="js/script.js"></script>
</body>
</html>