# Queen Florist - Installation Guide

## Cara Install di Hosting CPanel

### 1. Persiapan
Pastikan Anda memiliki:
- Akses ke CPanel hosting
- File manager CPanel
- Domain yang sudah pointing ke hosting

### 2. Upload File
1. Login ke CPanel
2. Buka **File Manager**
3. Masuk ke folder `public_html` (atau folder domain Anda)
4. Buat folder baru dengan nama `queen-florist` (opsional)
5. Upload semua file dari folder `queen-florist`:
   - `index.php`
   - Folder `css/` (beserta isinya)
   - Folder `js/` (beserta isinya)
   - Folder `assets/` (jika ada)

### 3. Permission Setting
Pastikan permission file dan folder sudah benar:
- Folder: 755
- File: 644

### 4. Testing
Buka browser dan akses:
- `https://domainanda.com/queen-florist/` (jika di folder)
- `https://domainanda.com/` (jika di root)

## Konfigurasi

### Ubah Nomor WhatsApp
Edit file `js/script.js`:
```javascript
// Ganti nomor ini
const whatsappUrl = `https://wa.me/6281223968122?text=${encodeURIComponent(message)}`;
```

Edit file `index.php`:
```html
<!-- Ganti nomor ini -->
<a href="https://wa.me/6281223968122?text=..." class="btn btn-whatsapp">
```

### Ubah Link Media Sosial
Edit file `index.php`:
```html
<a href="https://www.instagram.com/queen_florist.kebumen/" target="_blank">
<a href="https://www.tiktok.com/@queenflorist" target="_blank">
```

### Ubah Alamat & Maps
Edit file `index.php`:
```html
<!-- Ubah alamat -->
<p>Gg. Kutilang No.7, RT.03/RW.03, Panjer, Kecamatan Kebumen, Kabupaten Kebumen, Jawa Tengah 54312</p>

<!-- Ubah Google Maps iframe -->
<iframe src="URL_GOOGLE_MAPS_ANDA" width="100%" height="450">
```

## Troubleshooting

### Gambar Tidak Muncul
Pastikan URL gambar sudah benar dan bisa diakses. Jika gambar dari domain lain tidak muncul, bisa jadi karena:
- Hotlink protection di server hosting
- CORS policy
- URL gambar tidak valid

### WhatsApp Tidak Bekerja
Pastikan:
- Nomor WhatsApp sudah benar (dengan kode negara +62)
- Tidak ada spasi atau karakter khusus
- Format URL WhatsApp benar

### Form Tidak Terkirim
Periksa:
- JavaScript sudah di-enable di browser
- Tidak ada error di console (F12)
- Form validation berjalan dengan baik

## Customization

### Ubah Warna Tema
Edit file `css/style.css`:
```css
/* Ubah warna primer */
:root {
    --primary-color: #e91e63;
    --secondary-color: #9c27b0;
}
```

### Tambah Produk Baru
Edit file `js/script.js`:
```javascript
// Tambah di objek produkData
'nama-kategori-baru': {
    name: 'Nama Produk',
    image: 'URL_GAMBAR',
    description: 'Deskripsi produk'
}
```

### Ubah Teks
Edit langsung di file `index.php` untuk mengubah:
- Judul dan subtitle
- Deskripsi produk
- Testimoni
- Informasi kontak

## SEO Optimization

### Meta Tags
File `index.php` sudah dilengkapi dengan:
- Meta description
- Meta keywords
- Open Graph tags
- Responsive viewport

### Performance
- Lazy loading untuk gambar
- Minified CSS dan JS
- Optimized animations
- Caching headers

## Security

### Best Practices
- Validasi input form
- HTTPS untuk production
- Regular backup
- Update dependencies

---

Butuh bantuan? Hubungi:
📞 +6281223968122
💬 WhatsApp: https://wa.me/6281223968122