# 🌸 QUEEN Florist - Simple Version

Versi sederhana yang siap copy-paste ke XAMPP htdocs tanpa perlu instalasi Node.js.

## 🚀 Cara Install di XAMPP

### Step 1: Copy Folder
```bash
# Copy folder queen-florist-simple ke:
C:/xampp/htdocs/queen-florist/
```

### Step 2: Start XAMPP
1. Buka XAMPP Control Panel
2. Start Apache
3. (MySQL tidak diperlukan)

### Step 3: Akses Website
Buka browser dan kunjungi:
```
http://localhost/queen-florist/
```

## 🔐 Login Admin

### Akses Admin Panel
1. Scroll ke footer, klik link "Admin Panel"
2. Atau langsung buka: `http://localhost/queen-florist/#admin`

### Credentials
- **Username**: `queenflorist`
- **Password**: `password123`

## 📱 Fitur

### ✅ Frontend
- Landing page profesional dengan desain floral
- 10 kategori produk
- Filter kategori
- WhatsApp integration (3 titik)
- Responsive design
- Animasi smooth

### ✅ Backend
- Admin panel untuk CRUD produk
- Upload gambar (manual ke folder assets/images)
- Data tersimpan di browser (localStorage)
- Password terenkripsi

### ✅ WhatsApp Integration
- Hero section: Tombol Order via WhatsApp
- Product cards: Order via WhatsApp
- Contact section: WhatsApp button
- Form order dengan auto-generate message

## 📁 Struktur Folder

```
queen-florist/
├── index.html          # Halaman utama
├── style.css           # Styles
├── script.js           # JavaScript logic
├── assets/
│   └── images/         # Gambar produk
│       ├── standing-flower-1.jpg
│       ├── paper-flower-1.jpg
│       ├── duka-cita-1.jpg
│       ├── bouquet-1.jpg
│       ├── wedding-car-1.jpg
│       ├── balloon-decoration-1.jpg
│       ├── kado-rustic-1.jpg
│       ├── balloon-parcel-1.jpg
│       ├── snack-bouquet-1.jpg
│       └── tart-snack-1.jpg
├── README.md           # Instructions
└── .htaccess          # Apache config (opsional)
```

## 🎨 Customization

### Mengubah Nomor WhatsApp
Edit di `script.js`:
```javascript
const whatsappUrl = `https://wa.me/6281223968122?text=${encodeURIComponent(message)}`;
```

### Mengubah Password Admin
Edit di `script.js`:
```javascript
if (username === 'queenflorist' && password === 'password123') {
```

### Menambah Gambar
1. Upload gambar ke folder `assets/images/`
2. Di admin panel, masukkan nama file (contoh: `nama-gambar.jpg`)
3. Atau gunakan URL lengkap (contoh: `https://example.com/image.jpg`)

### Mengubah Warna Tema
Edit di `style.css`:
```css
:root {
    --primary-color: #ec4899;  /* Pink */
    --secondary-color: #a855f7; /* Purple */
    --success-color: #22c55e;  /* Green */
}
```

## 🔧 Troubleshooting

### Gambar Tidak Muncul
1. Pastikan file gambar ada di folder `assets/images/`
2. Check nama file (case-sensitive)
3. Verify path di admin panel

### Admin Login Gagal
1. Clear browser cache
2. Pastikan username dan password benar
3. Coba di incognito window

### WhatsApp Tidak Terbuka
1. Pastikan terkoneksi internet
2. Coba klik manual: `https://wa.me/6281223968122`
3. Check browser popup blocker

### CSS/JavaScript Tidak Berfungsi
1. Pastikan Apache sudah running
2. Check browser console (F12) untuk error
3. Clear browser cache

## 📱 Mobile Responsive

Website sudah dioptimalkan untuk:
- 📱 Mobile (320px+)
- 📱 Tablet (768px+)
- 💻 Desktop (1024px+)

## 🌐 Browser Support

- ✅ Chrome 60+
- ✅ Firefox 55+
- ✅ Safari 12+
- ✅ Edge 79+

## 🔒 Security

- Password admin menggunakan client-side validation
- Data tersimpan di localStorage (client-side)
- Tidak ada database yang dibutuhkan
- Aman untuk shared hosting

## 📊 Performance

- ⚡ Fast loading (CDN untuk CSS/JS)
- 🗜️ Optimized images
- 📦 Minimal dependencies
- 🚀 No build process required

## 🆘 Support

Jika ada masalah:
1. Check browser console (F12)
2. Verify file paths
3. Clear browser cache
4. Contact: +6281223968122

---

## ✅ Quick Start Checklist

- [ ] Copy folder ke `htdocs/`
- [ ] Start Apache di XAMPP
- [ ] Buka `http://localhost/queen-florist/`
- [ ] Test WhatsApp integration
- [ ] Login admin (queenflorist/password123)
- [ ] Add/edit products
- [ ] Test mobile responsive

🎉 **Selamat! QUEEN Florist siap online!**