<?php
require_once 'config/database.php';
require_once 'models/ProductModel.php';
require_once 'models/AgendaModel.php';
require_once 'models/TestimonialModel.php';
require_once 'controllers/ProductController.php';
require_once 'controllers/AgendaController.php';
require_once 'controllers/TestimonialController.php';

// Initialize controllers
$productController = new ProductController();
$agendaController = new AgendaController();
$testimonialController = new TestimonialController();

// Get data from models
$products = $productController->getAllProducts();
$agenda = $agendaController->getCurrentMonthAgenda();
$testimonials = $testimonialController->getAllTestimonials();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Queen Florist - Temukan Bunga Terindah untuk Setiap Momen</title>
    <meta name="description" content="Queen Florist - Pilihan bunga segar dan berkualitas untuk acara spesial Anda">
    <meta name="keywords" content="florist, bunga, bouquet, standing flower, wedding decoration">
    
    <!-- CSS -->
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/images/favicon.ico">
</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="container">
            <div class="header-content">
                <div class="logo">
                    <div class="logo-icon">👑</div>
                    <h1>QUEEN Florist</h1>
                </div>
                <nav class="nav-menu">
                    <a href="#beranda" class="nav-link">Beranda</a>
                    <a href="#agenda" class="nav-link">Agenda</a>
                    <a href="#produk" class="nav-link">Produk</a>
                    <a href="#kontak" class="nav-link">Kontak</a>
                </nav>
                <a href="https://wa.me/6281223968122?text=Hai%20kak%20mimin%20yang%20baik%20hati,%20bisa%20diinfokan…" 
                   class="whatsapp-btn" target="_blank">
                    <i class="fab fa-whatsapp"></i>
                    <span>Chat Admin</span>
                </a>
            </div>
        </div>
    </header>

    <!-- Hero Section -->
    <section id="beranda" class="hero">
        <div class="hero-background">
            <img src="https://i.imgur.com/dtZPmsz.jpeg" alt="Hero Background">
            <div class="hero-overlay"></div>
        </div>
        <div class="hero-content">
            <h1 class="hero-title">Temukan Bunga Terindah untuk Setiap Momen</h1>
            <p class="hero-subtitle">Pilihan bunga segar dan berkualitas untuk acara spesial Anda</p>
            <div class="hero-buttons">
                <a href="#produk" class="btn btn-primary">
                    <i class="fas fa-shopping-bag"></i>
                    Lihat Produk
                </a>
                <a href="https://wa.me/6281223968122?text=Hai%20kak%20mimin%20yang%20baik%20hati,%20bisa%20diinfokan…" 
                   class="btn btn-whatsapp" target="_blank">
                    <i class="fab fa-whatsapp"></i>
                    Chat Admin
                </a>
            </div>
        </div>
        <div class="scroll-indicator">
            <i class="fas fa-chevron-down"></i>
        </div>
    </section>

    <!-- Agenda Section -->
    <section id="agenda" class="agenda">
        <div class="container">
            <div class="section-header">
                <h2>Agenda Bulan Ini</h2>
                <p>Peringatan dan acara penting pada bulan ini</p>
            </div>
            <div class="agenda-grid">
                <?php foreach ($agenda as $item): ?>
                <div class="agenda-card">
                    <div class="agenda-icon">
                        <i class="fas fa-calendar"></i>
                        <span class="agenda-date"><?php echo date('d', strtotime($item['date'])); ?> Oktober</span>
                    </div>
                    <h3><?php echo htmlspecialchars($item['title']); ?></h3>
                    <p><?php echo htmlspecialchars($item['description']); ?></p>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- Products Section -->
    <section id="produk" class="products">
        <div class="container">
            <div class="section-header">
                <h2>Produk Kami</h2>
                <p>Berbagai pilihan bunga dan dekorasi untuk kebutuhan Anda</p>
            </div>
            <div class="products-grid">
                <?php foreach ($products as $product): ?>
                <div class="product-card">
                    <div class="product-image">
                        <img src="<?php echo htmlspecialchars($product['image_url']); ?>" 
                             alt="<?php echo htmlspecialchars($product['name']); ?>">
                        <div class="product-icon"><?php echo htmlspecialchars($product['icon']); ?></div>
                    </div>
                    <div class="product-info">
                        <h3><?php echo htmlspecialchars($product['name']); ?></h3>
                        <button class="btn btn-order" 
                                onclick="openOrderModal('<?php echo htmlspecialchars($product['name']); ?>', 
                                                      '<?php echo htmlspecialchars($product['category']); ?>', 
                                                      '<?php echo htmlspecialchars($product['image_url']); ?>')">
                            <i class="fab fa-whatsapp"></i>
                            Order Sekarang
                        </button>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- Testimonials Section -->
    <section class="testimonials">
        <div class="container">
            <div class="section-header">
                <h2>Testimoni Pelanggan</h2>
                <p>Apa kata pelanggan setia kami</p>
            </div>
            <div class="testimonials-grid">
                <?php foreach ($testimonials as $testimonial): ?>
                <div class="testimonial-card">
                    <div class="testimonial-rating">
                        <?php for ($i = 0; $i < $testimonial['rating']; $i++): ?>
                        <i class="fas fa-star"></i>
                        <?php endfor; ?>
                    </div>
                    <p class="testimonial-message">"<?php echo htmlspecialchars($testimonial['message']); ?>"</p>
                    <p class="testimonial-name">- <?php echo htmlspecialchars($testimonial['name']); ?></p>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    <section id="kontak" class="contact">
        <div class="container">
            <div class="section-header">
                <h2>Kontak Kami</h2>
                <p>Hubungi kami untuk pemesanan dan informasi lebih lanjut</p>
            </div>
            <div class="contact-grid">
                <div class="contact-card">
                    <div class="contact-icon">
                        <i class="fas fa-map-marker-alt"></i>
                        <h3>Alamat</h3>
                    </div>
                    <p>Gg. Kutilang No.7, RT.03/RW.03, Panjer, Kec. Kebumen, Kabupaten Kebumen, Jawa Tengah 54312</p>
                </div>
                <div class="contact-card">
                    <div class="contact-icon">
                        <i class="fas fa-phone"></i>
                        <h3>Telepon</h3>
                    </div>
                    <p><a href="tel:+6281223968122">+6281223968122</a></p>
                </div>
            </div>
            <div class="social-links">
                <a href="https://www.instagram.com/queen_florist.kebumen/" target="_blank" class="social-link instagram">
                    <i class="fab fa-instagram"></i>
                </a>
                <a href="https://www.tiktok.com/@queenflorist" target="_blank" class="social-link tiktok">
                    <i class="fab fa-tiktok"></i>
                </a>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <p>© 2025 Queen Florist | brainmultimedia All rights reserved.</p>
            <p>Your trusted florist partner for every special moment</p>
        </div>
    </footer>

    <!-- Order Modal -->
    <div id="orderModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3>Pesan <span id="modalProductName"></span></h3>
                <button class="close-btn" onclick="closeOrderModal()">&times;</button>
            </div>
            <div class="modal-body">
                <div class="product-preview">
                    <img id="modalProductImage" src="" alt="">
                    <div class="product-info">
                        <h4 id="modalProductTitle"></h4>
                        <p>Kategori: <span id="modalProductCategory"></span></p>
                        <div class="product-link">
                            <strong>Link Foto:</strong><br>
                            <a id="modalProductLink" href="" target="_blank"></a>
                        </div>
                    </div>
                </div>
                <form id="orderForm">
                    <div class="form-group">
                        <label for="customerName">Nama *</label>
                        <input type="text" id="customerName" name="name" required>
                    </div>
                    <div class="form-group">
                        <label for="customerNote">Catatan</label>
                        <textarea id="customerNote" name="note" rows="3"></textarea>
                    </div>
                    <div class="form-group">
                        <label for="customerAddress">Alamat Kirim *</label>
                        <textarea id="customerAddress" name="address" rows="3" required></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeOrderModal()">Batal</button>
                <button type="button" class="btn btn-primary" onclick="submitOrder()">Kirim ke WhatsApp</button>
            </div>
        </div>
    </div>

    <!-- Image Modal -->
    <div id="imageModal" class="modal">
        <div class="modal-image-content">
            <button class="close-image-btn" onclick="closeImageModal()">&times;</button>
            <img id="modalImage" src="" alt="">
            <div class="image-info">
                <p><strong>Link Foto:</strong> <a id="modalImageLink" href="" target="_blank"></a></p>
            </div>
        </div>
    </div>

    <!-- JavaScript -->
    <script src="assets/js/script.js"></script>
</body>
</html>