<?php
/**
 * Queen Florist - Deployment Script
 * This script helps with initial deployment and setup
 */

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if this is first time setup
$setupFile = __DIR__ . '/config/setup_complete.txt';
if (!file_exists($setupFile)) {
    // First time setup
    echo "<!DOCTYPE html>
    <html>
    <head>
        <title>Queen Florist - Setup</title>
        <style>
            body { font-family: Arial, sans-serif; max-width: 800px; margin: 50px auto; padding: 20px; }
            .container { background: #f8f9fa; padding: 30px; border-radius: 10px; }
            .success { color: #28a745; }
            .error { color: #dc3545; }
            .warning { color: #ffc107; }
            .btn { background: #ec4899; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; }
            .form-group { margin-bottom: 15px; }
            label { display: block; margin-bottom: 5px; font-weight: bold; }
            input, select { width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px; }
        </style>
    </head>
    <body>
        <div class='container'>
            <h1>🌸 Queen Florist - Setup Assistant</h1>
            
            <h2>System Requirements Check</h2>";
    
    // Check PHP version
    $phpVersion = PHP_VERSION;
    echo "<p>PHP Version: <span class='" . (version_compare($phpVersion, '7.4.0', '>=') ? 'success' : 'error') . "'>" . $phpVersion . "</span></p>";
    
    // Check required extensions
    $requiredExtensions = ['mysqli', 'mbstring', 'json'];
    foreach ($requiredExtensions as $ext) {
        $loaded = extension_loaded($ext);
        echo "<p>PHP Extension '$ext': <span class='" . ($loaded ? 'success' : 'error') . "'>" . ($loaded ? 'Loaded' : 'Missing') . "</span></p>";
    }
    
    // Check database connection
    echo "<h2>Database Configuration</h2>";
    
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $host = $_POST['host'] ?? 'localhost';
        $username = $_POST['username'] ?? '';
        $password = $_POST['password'] ?? '';
        $database = $_POST['database'] ?? '';
        
        // Test database connection
        try {
            $conn = new mysqli($host, $username, $password, $database);
            if ($conn->connect_error) {
                echo "<p class='error'>Database connection failed: " . $conn->connect_error . "</p>";
            } else {
                echo "<p class='success'>Database connection successful!</p>";
                
                // Create config file
                $configContent = "<?php
/**
 * Database Configuration
 * Queen Florist - MVC Architecture
 */

class Database {
    private \$host = '$host';
    private \$username = '$username';
    private \$password = '$password';
    private \$database = '$database';
    private \$connection;
    
    public function __construct() {
        \$this->connect();
    }
    
    private function connect() {
        try {
            \$this->connection = new mysqli(\$this->host, \$this->username, \$this->password, \$this->database);
            
            if (\$this->connection->connect_error) {
                throw new Exception(\"Connection failed: \" . \$this->connection->connect_error);
            }
            
            // Set charset to utf8mb4
            \$this->connection->set_charset(\"utf8mb4\");
            
        } catch (Exception \$e) {
            die(\"Database connection error: \" . \$e->getMessage());
        }
    }
    
    public function getConnection() {
        return \$this->connection;
    }
    
    public function query(\$sql) {
        return \$this->connection->query(\$sql);
    }
    
    public function prepare(\$sql) {
        return \$this->connection->prepare(\$sql);
    }
    
    public function escape(\$string) {
        return \$this->connection->real_escape_string(\$string);
    }
    
    public function getLastInsertId() {
        return \$this->connection->insert_id;
    }
    
    public function close() {
        if (\$this->connection) {
            \$this->connection->close();
        }
    }
    
    // Prevent cloning of instance
    private function __clone() {}
    
    // Prevent unserialization of instance
    public function __wakeup() {
        throw new Exception(\"Cannot unserialize singleton\");
    }
}

// Create database instance
\$database = new Database();
\$conn = \$database->getConnection();
?>";
                
                if (file_put_contents(__DIR__ . '/config/database.php', $configContent)) {
                    echo "<p class='success'>Database configuration saved!</p>";
                    
                    // Create setup complete flag
                    file_put_contents($setupFile, 'Setup completed on ' . date('Y-m-d H:i:s'));
                    
                    echo "<p class='success'><strong>Setup completed successfully!</strong></p>";
                    echo "<p><a href='index.php' class='btn'>Go to Website</a></p>";
                    echo "<script>setTimeout(function() { window.location.href = 'index.php'; }, 3000);</script>";
                } else {
                    echo "<p class='error'>Failed to save configuration file!</p>";
                }
                
                $conn->close();
            }
        } catch (Exception $e) {
            echo "<p class='error'>Database error: " . $e->getMessage() . "</p>";
        }
    } else {
        echo "<form method='post'>
            <div class='form-group'>
                <label for='host'>Database Host:</label>
                <input type='text' id='host' name='host' value='localhost' required>
            </div>
            <div class='form-group'>
                <label for='username'>Database Username:</label>
                <input type='text' id='username' name='username' required>
            </div>
            <div class='form-group'>
                <label for='password'>Database Password:</label>
                <input type='password' id='password' name='password'>
            </div>
            <div class='form-group'>
                <label for='database'>Database Name:</label>
                <input type='text' id='database' name='database' required>
            </div>
            <button type='submit' class='btn'>Test Connection & Save Config</button>
        </form>";
    }
    
    echo "
        <h2>Next Steps</h2>
        <ol>
            <li>Make sure you have created the database</li>
            <li>Import the SQL file: <code>queen_florist_database.sql</code></li>
            <li>Configure database connection above</li>
            <li>Visit your website homepage</li>
        </ol>
        
        <h2>Important Files</h2>
        <ul>
            <li><strong>Database:</strong> queen_florist_database.sql</li>
            <li><strong>Main Page:</strong> index.php</li>
            <li><strong>Styles:</strong> assets/css/style.css</li>
            <li><strong>Scripts:</strong> assets/js/script.js</li>
        </ul>
        </div>
    </body>
    </html>";
    exit;
}

// If setup is complete, redirect to main site
header('Location: index.php');
exit;
?>