<?php
$page_title = 'Detail Produk';
ob_start();
?>

<!-- Page Header -->
<div class="page-header">
    <div class="page-header-content">
        <div class="page-header-left">
            <h2>Detail Produk</h2>
            <p>Lihat informasi lengkap produk</p>
        </div>
        <div class="page-header-right">
            <a href="index.php?page=products" class="btn btn-outline">
                <i class="fas fa-arrow-left"></i>
                Kembali
            </a>
            <a href="index.php?page=products_edit&id=<?php echo $product['id']; ?>" class="btn btn-primary">
                <i class="fas fa-edit"></i>
                Edit
            </a>
        </div>
    </div>
</div>

<!-- Product Detail -->
<div class="card">
    <div class="card-body">
        <div class="product-detail">
            <div class="product-detail-header">
                <div class="product-image-large">
                    <?php if (!empty($product['image_url'])): ?>
                        <img src="<?php echo htmlspecialchars($product['image_url']); ?>" alt="<?php echo htmlspecialchars($product['name']); ?>">
                    <?php else: ?>
                        <div class="no-image-large">
                            <i class="fas fa-image"></i>
                            <p>Tidak Ada Gambar</p>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="product-info-section">
                    <h1><?php echo htmlspecialchars($product['name']); ?></h1>
                    <div class="product-meta">
                        <span class="badge badge-info"><?php echo htmlspecialchars($product['category']); ?></span>
                        <?php if ($product['is_best_seller']): ?>
                            <span class="badge badge-warning">
                                <i class="fas fa-star"></i>
                                Best Seller
                            </span>
                        <?php endif; ?>
                    </div>
                    <div class="product-price">
                        <h2>Rp <?php echo number_format($product['price'], 0, ',', '.'); ?></h2>
                    </div>
                    <?php if (!empty($product['icon'])): ?>
                        <div class="product-icon">
                            <i class="fas <?php echo htmlspecialchars($product['icon']); ?>"></i>
                            <span><?php echo htmlspecialchars($product['icon']); ?></span>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="product-content">
                <h3>Deskripsi Produk</h3>
                <div class="description-content">
                    <?php echo nl2br(htmlspecialchars($product['description'])); ?>
                </div>
            </div>
            
            <div class="product-info">
                <h3>Informasi Tambahan</h3>
                <div class="info-grid">
                    <div class="info-item">
                        <label>ID Produk:</label>
                        <span>#<?php echo $product['id']; ?></span>
                    </div>
                    <div class="info-item">
                        <label>Kategori:</label>
                        <span><?php echo htmlspecialchars($product['category']); ?></span>
                    </div>
                    <div class="info-item">
                        <label>Harga:</label>
                        <span>Rp <?php echo number_format($product['price'], 0, ',', '.'); ?></span>
                    </div>
                    <div class="info-item">
                        <label>Status:</label>
                        <span>
                            <?php if ($product['is_best_seller']): ?>
                                <span class="badge badge-success">Best Seller</span>
                            <?php else: ?>
                                <span class="badge badge-secondary">Normal</span>
                            <?php endif; ?>
                        </span>
                    </div>
                    <div class="info-item">
                        <label>Dibuat Oleh:</label>
                        <span><?php echo htmlspecialchars($product['created_by_name'] ?? 'System'); ?></span>
                    </div>
                    <div class="info-item">
                        <label>Dibuat Pada:</label>
                        <span><?php echo date('d M Y, H:i', strtotime($product['created_at'])); ?></span>
                    </div>
                    <?php if ($product['updated_at']): ?>
                    <div class="info-item">
                        <label>Diperbarui Oleh:</label>
                        <span><?php echo htmlspecialchars($product['updated_by_name'] ?? 'System'); ?></span>
                    </div>
                    <div class="info-item">
                        <label>Diperbarui Pada:</label>
                        <span><?php echo date('d M Y, H:i', strtotime($product['updated_at'])); ?></span>
                    </div>
                    <?php endif; ?>
                    <?php if (!empty($product['image_url'])): ?>
                    <div class="info-item full-width">
                        <label>URL Gambar:</label>
                        <div class="url-container">
                            <input type="text" value="<?php echo htmlspecialchars($product['image_url']); ?>" readonly class="url-input">
                            <button class="btn btn-sm btn-outline" onclick="copyToClipboard('<?php echo htmlspecialchars($product['image_url']); ?>')">
                                <i class="fas fa-copy"></i>
                                Salin
                            </button>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Actions -->
<div class="card">
    <div class="card-body">
        <div class="action-buttons">
            <a href="index.php?page=products_edit&id=<?php echo $product['id']; ?>" class="btn btn-primary">
                <i class="fas fa-edit"></i>
                Edit Produk
            </a>
            
            <form method="POST" action="index.php?page=products_toggle_best_seller&id=<?php echo $product['id']; ?>" style="display: inline-block;">
                <button type="submit" class="btn <?php echo $product['is_best_seller'] ? 'btn-warning' : 'btn-success'; ?>">
                    <i class="fas fa-<?php echo $product['is_best_seller'] ? 'star' : 'star'; ?>"></i>
                    <?php echo $product['is_best_seller'] ? 'Hapus dari Best Seller' : 'Jadikan Best Seller'; ?>
                </button>
            </form>
            
            <form method="POST" action="index.php?page=products_delete&id=<?php echo $product['id']; ?>" style="display: inline-block;" onsubmit="return confirm('Apakah Anda yakin ingin menghapus produk ini? Tindakan ini tidak dapat dibatalkan.')">
                <button type="submit" class="btn btn-danger">
                    <i class="fas fa-trash"></i>
                    Hapus Produk
                </button>
            </form>
            
            <a href="index.php?page=products" class="btn btn-outline">
                <i class="fas fa-arrow-left"></i>
                Kembali ke Daftar
            </a>
        </div>
    </div>
</div>

<style>
.product-detail {
    max-width: 900px;
    margin: 0 auto;
}

.product-detail-header {
    display: flex;
    align-items: flex-start;
    gap: 2rem;
    margin-bottom: 2rem;
    padding-bottom: 2rem;
    border-bottom: 1px solid #e5e7eb;
}

.product-image-large {
    flex-shrink: 0;
    width: 300px;
    height: 300px;
    border-radius: 1rem;
    overflow: hidden;
    border: 1px solid #e5e7eb;
    box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
}

.product-image-large img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.no-image-large {
    width: 300px;
    height: 300px;
    background: #f3f4f6;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    color: #9ca3af;
    border-radius: 1rem;
    border: 1px solid #e5e7eb;
}

.no-image-large i {
    font-size: 3rem;
    margin-bottom: 1rem;
}

.product-info-section {
    flex: 1;
}

.product-info-section h1 {
    margin: 0 0 1rem 0;
    color: #1f2937;
    font-size: 2rem;
    font-weight: 700;
}

.product-meta {
    display: flex;
    gap: 0.5rem;
    flex-wrap: wrap;
    margin-bottom: 1rem;
}

.product-price h2 {
    margin: 0 0 1rem 0;
    color: #059669;
    font-size: 2.5rem;
    font-weight: 700;
}

.product-icon {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    color: #6b7280;
    font-size: 0.875rem;
}

.product-content {
    margin-bottom: 2rem;
}

.product-content h3 {
    margin: 0 0 1rem 0;
    color: #374151;
    font-size: 1.25rem;
    font-weight: 600;
}

.description-content {
    background: #f9fafb;
    padding: 1.5rem;
    border-radius: 0.75rem;
    border-left: 4px solid #3b82f6;
    line-height: 1.6;
    color: #4b5563;
}

.product-info h3 {
    margin: 0 0 1rem 0;
    color: #374151;
    font-size: 1.25rem;
    font-weight: 600;
}

.info-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1rem;
}

.info-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0.75rem;
    background: #f9fafb;
    border-radius: 0.5rem;
}

.info-item.full-width {
    grid-column: 1 / -1;
    flex-direction: column;
    align-items: flex-start;
    gap: 0.5rem;
}

.info-item label {
    font-weight: 500;
    color: #6b7280;
}

.info-item span {
    color: #1f2937;
    font-weight: 500;
}

.url-container {
    display: flex;
    gap: 0.5rem;
    width: 100%;
}

.url-input {
    flex: 1;
    padding: 0.5rem;
    border: 1px solid #d1d5db;
    border-radius: 0.375rem;
    background: white;
    font-family: monospace;
    font-size: 0.875rem;
}

.action-buttons {
    display: flex;
    gap: 1rem;
    flex-wrap: wrap;
    justify-content: center;
}

@media (max-width: 768px) {
    .product-detail-header {
        flex-direction: column;
        align-items: center;
        text-align: center;
    }
    
    .product-image-large,
    .no-image-large {
        width: 100%;
        max-width: 300px;
        height: 250px;
    }
    
    .product-info-section h1 {
        font-size: 1.5rem;
    }
    
    .product-price h2 {
        font-size: 2rem;
    }
    
    .action-buttons {
        flex-direction: column;
    }
    
    .action-buttons .btn {
        width: 100%;
    }
    
    .url-container {
        flex-direction: column;
    }
}
</style>

<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        // Show success message
        const btn = event.target.closest('button');
        const originalHTML = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-check"></i> Tersalin!';
        btn.classList.add('btn-success');
        btn.classList.remove('btn-outline');
        
        setTimeout(() => {
            btn.innerHTML = originalHTML;
            btn.classList.remove('btn-success');
            btn.classList.add('btn-outline');
        }, 2000);
    }).catch(function(err) {
        console.error('Failed to copy: ', err);
        alert('Gagal menyalin URL');
    });
}
</script>

<?php
$content = ob_get_clean();
include __DIR__ . '/layout.php';
?>