<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Queen Florist Admin</title>
    <link rel="stylesheet" href="assets/css/admin.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <div class="admin-container">
        <!-- Sidebar -->
        <aside class="sidebar" id="sidebar">
            <div class="sidebar-header">
                <div class="logo">
                    <span class="logo-icon">🌸</span>
                    <span class="logo-text">Queen Florist</span>
                </div>
                <button class="sidebar-toggle" id="sidebarToggle">
                    <i class="fas fa-bars"></i>
                </button>
            </div>
            
            <nav class="sidebar-nav">
                <ul class="nav-list">
                    <li class="nav-item">
                        <a href="index.php?page=dashboard" class="nav-link <?php echo ($_GET['page'] ?? '') === 'dashboard' ? 'active' : ''; ?>">
                            <i class="fas fa-tachometer-alt"></i>
                            <span>Dashboard</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="index.php?page=agenda" class="nav-link <?php echo ($_GET['page'] ?? '') === 'agenda' ? 'active' : ''; ?>">
                            <i class="fas fa-calendar-alt"></i>
                            <span>Agenda</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="index.php?page=products" class="nav-link <?php echo ($_GET['page'] ?? '') === 'products' ? 'active' : ''; ?>">
                            <i class="fas fa-box"></i>
                            <span>Produk</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="index.php?page=activity_logs" class="nav-link <?php echo ($_GET['page'] ?? '') === 'activity_logs' ? 'active' : ''; ?>">
                            <i class="fas fa-history"></i>
                            <span>Aktivitas</span>
                        </a>
                    </li>
                    <?php if ($_SESSION['admin_role'] === 'admin'): ?>
                    <li class="nav-item">
                        <a href="index.php?page=admin_management" class="nav-link <?php echo ($_GET['page'] ?? '') === 'admin_management' ? 'active' : ''; ?>">
                            <i class="fas fa-users-cog"></i>
                            <span>Admin</span>
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
                
                <div class="nav-footer">
                    <div class="user-info">
                        <div class="user-avatar">
                            <i class="fas fa-user-circle"></i>
                        </div>
                        <div class="user-details">
                            <div class="user-name"><?php echo htmlspecialchars($_SESSION['admin_name']); ?></div>
                            <div class="user-role"><?php echo htmlspecialchars(ucfirst($_SESSION['admin_role'])); ?></div>
                        </div>
                    </div>
                    
                    <ul class="nav-list">
                        <li class="nav-item">
                            <a href="index.php?page=profile" class="nav-link">
                                <i class="fas fa-user"></i>
                                <span>Profil</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="index.php?page=change_password" class="nav-link">
                                <i class="fas fa-key"></i>
                                <span>Ubah Password</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="index.php?page=logout" class="nav-link logout">
                                <i class="fas fa-sign-out-alt"></i>
                                <span>Logout</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </nav>
        </aside>
        
        <!-- Main Content -->
        <main class="main-content">
            <!-- Header -->
            <header class="header">
                <div class="header-left">
                    <button class="mobile-sidebar-toggle" id="mobileSidebarToggle">
                        <i class="fas fa-bars"></i>
                    </button>
                    <h1 class="page-title">Dashboard</h1>
                </div>
                <div class="header-right">
                    <div class="header-time" id="headerTime"></div>
                </div>
            </header>
            
            <!-- Content -->
            <div class="content">
                <?php if (isset($_SESSION['success'])): ?>
                    <div class="alert alert-success">
                        <?php 
                        echo htmlspecialchars($_SESSION['success']);
                        unset($_SESSION['success']);
                        ?>
                    </div>
                <?php endif; ?>
                
                <?php if (isset($_SESSION['error'])): ?>
                    <div class="alert alert-error">
                        <?php 
                        echo htmlspecialchars($_SESSION['error']);
                        unset($_SESSION['error']);
                        ?>
                    </div>
                <?php endif; ?>
                
                <!-- Stats Cards -->
                <div class="stats-grid">
                    <div class="stat-card">
                        <div class="stat-icon blue">
                            <i class="fas fa-box"></i>
                        </div>
                        <div class="stat-content">
                            <div class="stat-number"><?php echo number_format($stats['total_products']); ?></div>
                            <div class="stat-label">Total Produk</div>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon green">
                            <i class="fas fa-calendar-alt"></i>
                        </div>
                        <div class="stat-content">
                            <div class="stat-number"><?php echo number_format($stats['total_agenda']); ?></div>
                            <div class="stat-label">Total Agenda</div>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon purple">
                            <i class="fas fa-users"></i>
                        </div>
                        <div class="stat-content">
                            <div class="stat-number"><?php echo number_format($stats['active_admins']); ?></div>
                            <div class="stat-label">Admin Aktif</div>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon orange">
                            <i class="fas fa-chart-line"></i>
                        </div>
                        <div class="stat-content">
                            <div class="stat-number"><?php echo number_format($stats['today_activities']); ?></div>
                            <div class="stat-label">Aktivitas Hari Ini</div>
                        </div>
                    </div>
                </div>
                
                <!-- Dashboard Content -->
                <div class="dashboard-grid">
                    <!-- Upcoming Agenda -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Agenda Mendatang</h3>
                            <a href="index.php?page=agenda" class="btn btn-sm btn-outline">Lihat Semua</a>
                        </div>
                        <div class="card-body">
                            <?php if (empty($upcomingAgenda)): ?>
                                <p class="text-muted">Tidak ada agenda mendatang</p>
                            <?php else: ?>
                                <div class="agenda-list">
                                    <?php foreach ($upcomingAgenda as $item): ?>
                                        <div class="agenda-item">
                                            <div class="agenda-date">
                                                <div class="date-day"><?php echo date('d', strtotime($item['date'])); ?></div>
                                                <div class="date-month"><?php echo date('M', strtotime($item['date'])); ?></div>
                                            </div>
                                            <div class="agenda-content">
                                                <h4 class="agenda-title"><?php echo htmlspecialchars($item['title']); ?></h4>
                                                <p class="agenda-desc"><?php echo htmlspecialchars(substr($item['description'], 0, 100)) . '...'; ?></p>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <!-- Recent Products -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Produk Terbaru</h3>
                            <a href="index.php?page=products" class="btn btn-sm btn-outline">Lihat Semua</a>
                        </div>
                        <div class="card-body">
                            <?php if (empty($recentProducts)): ?>
                                <p class="text-muted">Belum ada produk</p>
                            <?php else: ?>
                                <div class="product-list">
                                    <?php foreach ($recentProducts as $product): ?>
                                        <div class="product-item">
                                            <div class="product-image">
                                                <?php if (!empty($product['image_url'])): ?>
                                                    <img src="<?php echo htmlspecialchars($product['image_url']); ?>" alt="<?php echo htmlspecialchars($product['name']); ?>">
                                                <?php else: ?>
                                                    <div class="no-image">
                                                        <i class="fas fa-image"></i>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                            <div class="product-content">
                                                <h4 class="product-name"><?php echo htmlspecialchars($product['name']); ?></h4>
                                                <p class="product-price">Rp <?php echo number_format($product['price'], 0, ',', '.'); ?></p>
                                                <span class="product-category"><?php echo htmlspecialchars($product['category']); ?></span>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <!-- Recent Activities -->
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Aktivitas Terbaru</h3>
                        <a href="index.php?page=activity_logs" class="btn btn-sm btn-outline">Lihat Semua</a>
                    </div>
                    <div class="card-body">
                        <?php if (empty($recentActivities)): ?>
                            <p class="text-muted">Belum ada aktivitas</p>
                        <?php else: ?>
                            <div class="activity-list">
                                <?php foreach ($recentActivities as $activity): ?>
                                    <div class="activity-item">
                                        <div class="activity-icon">
                                            <i class="fas fa-<?php echo $this->getActivityIcon($activity['action']); ?>"></i>
                                        </div>
                                        <div class="activity-content">
                                            <div class="activity-text">
                                                <strong><?php echo htmlspecialchars($activity['username'] ?? 'Unknown'); ?></strong>
                                                <?php echo $this->getActivityText($activity['action'], $activity['description']); ?>
                                            </div>
                                            <div class="activity-time">
                                                <?php echo $this->formatTime($activity['created_at']); ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </main>
    </div>
    
    <script src="assets/js/admin.js"></script>
    <script>
        // Update header time
        function updateHeaderTime() {
            const now = new Date();
            const options = { 
                weekday: 'long', 
                year: 'numeric', 
                month: 'long', 
                day: 'numeric',
                hour: '2-digit',
                minute: '2-digit'
            };
            document.getElementById('headerTime').textContent = now.toLocaleDateString('id-ID', options);
        }
        
        updateHeaderTime();
        setInterval(updateHeaderTime, 60000); // Update every minute
    </script>
</body>
</html>