<?php
/**
 * Queen Florist Admin Panel - Main Entry Point
 * This is the main router and controller loader
 */

// Start session
session_start();

// Error reporting for development
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Define constants
define('ADMIN_PATH', __DIR__);
define('ROOT_PATH', dirname(__DIR__));

// Load configuration
require_once ROOT_PATH . '/config/database.php';

// Initialize database connection
try {
    $db = Database::getInstance();
} catch (Exception $e) {
    die('Database connection failed: ' . $e->getMessage());
}

// Get current page
$page = $_GET['page'] ?? 'login';

// Authentication check
$publicPages = ['login', 'login_process', 'logout'];
if (!in_array($page, $publicPages)) {
    session_start();
    if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
        header('Location: index.php?page=login');
        exit;
    }
}

// Route to appropriate controller
switch ($page) {
    // Authentication routes
    case 'login':
        require_once ADMIN_PATH . '/controllers/AuthController.php';
        $auth = new AuthController();
        $auth->showLogin();
        break;
        
    case 'login_process':
        require_once ADMIN_PATH . '/controllers/AuthController.php';
        $auth = new AuthController();
        $auth->login();
        break;
        
    case 'logout':
        require_once ADMIN_PATH . '/controllers/AuthController.php';
        $auth = new AuthController();
        $auth->logout();
        break;
        
    case 'change_password':
        require_once ADMIN_PATH . '/controllers/AuthController.php';
        $auth = new AuthController();
        $auth->showChangePassword();
        break;
        
    case 'change_password_process':
        require_once ADMIN_PATH . '/controllers/AuthController.php';
        $auth = new AuthController();
        $auth->changePassword();
        break;
        
    // Dashboard routes
    case 'dashboard':
        require_once ADMIN_PATH . '/controllers/DashboardController.php';
        $dashboard = new DashboardController();
        $dashboard->showDashboard();
        break;
        
    case 'profile':
        require_once ADMIN_PATH . '/controllers/DashboardController.php';
        $dashboard = new DashboardController();
        $dashboard->showProfile();
        break;
        
    case 'profile_update':
        require_once ADMIN_PATH . '/controllers/DashboardController.php';
        $dashboard = new DashboardController();
        $dashboard->updateProfile();
        break;
        
    case 'activity_logs':
        require_once ADMIN_PATH . '/controllers/DashboardController.php';
        $dashboard = new DashboardController();
        $dashboard->showActivityLogs();
        break;
        
    case 'admin_management':
        require_once ADMIN_PATH . '/controllers/DashboardController.php';
        $dashboard = new DashboardController();
        $dashboard->showAdminManagement();
        break;
        
    case 'admin_create':
        require_once ADMIN_PATH . '/controllers/DashboardController.php';
        $dashboard = new DashboardController();
        $dashboard->createAdmin();
        break;
        
    case 'admin_toggle_status':
        require_once ADMIN_PATH . '/controllers/DashboardController.php';
        $dashboard = new DashboardController();
        $id = $_GET['id'] ?? 0;
        $dashboard->toggleAdminStatus($id);
        break;
        
    // Agenda routes
    case 'agenda':
        require_once ADMIN_PATH . '/controllers/AgendaController.php';
        $agenda = new AgendaController();
        $agenda->index();
        break;
        
    case 'agenda_create':
        require_once ADMIN_PATH . '/controllers/AgendaController.php';
        $agenda = new AgendaController();
        $agenda->create();
        break;
        
    case 'agenda_store':
        require_once ADMIN_PATH . '/controllers/AgendaController.php';
        $agenda = new AgendaController();
        $agenda->store();
        break;
        
    case 'agenda_edit':
        require_once ADMIN_PATH . '/controllers/AgendaController.php';
        $agenda = new AgendaController();
        $id = $_GET['id'] ?? 0;
        $agenda->edit($id);
        break;
        
    case 'agenda_update':
        require_once ADMIN_PATH . '/controllers/AgendaController.php';
        $agenda = new AgendaController();
        $id = $_GET['id'] ?? 0;
        $agenda->update($id);
        break;
        
    case 'agenda_view':
        require_once ADMIN_PATH . '/controllers/AgendaController.php';
        $agenda = new AgendaController();
        $id = $_GET['id'] ?? 0;
        $agenda->view($id);
        break;
        
    case 'agenda_delete':
        require_once ADMIN_PATH . '/controllers/AgendaController.php';
        $agenda = new AgendaController();
        $id = $_GET['id'] ?? 0;
        $agenda->delete($id);
        break;
        
    case 'agenda_bulk_delete':
        require_once ADMIN_PATH . '/controllers/AgendaController.php';
        $agenda = new AgendaController();
        $agenda->bulkDelete();
        break;
        
    // Products routes
    case 'products':
        require_once ADMIN_PATH . '/controllers/ProductController.php';
        $product = new ProductController();
        $product->index();
        break;
        
    case 'products_create':
        require_once ADMIN_PATH . '/controllers/ProductController.php';
        $product = new ProductController();
        $product->create();
        break;
        
    case 'products_store':
        require_once ADMIN_PATH . '/controllers/ProductController.php';
        $product = new ProductController();
        $product->store();
        break;
        
    case 'products_edit':
        require_once ADMIN_PATH . '/controllers/ProductController.php';
        $product = new ProductController();
        $id = $_GET['id'] ?? 0;
        $product->edit($id);
        break;
        
    case 'products_update':
        require_once ADMIN_PATH . '/controllers/ProductController.php';
        $product = new ProductController();
        $id = $_GET['id'] ?? 0;
        $product->update($id);
        break;
        
    case 'products_view':
        require_once ADMIN_PATH . '/controllers/ProductController.php';
        $product = new ProductController();
        $id = $_GET['id'] ?? 0;
        $product->view($id);
        break;
        
    case 'products_delete':
        require_once ADMIN_PATH . '/controllers/ProductController.php';
        $product = new ProductController();
        $id = $_GET['id'] ?? 0;
        $product->delete($id);
        break;
        
    case 'products_bulk_delete':
        require_once ADMIN_PATH . '/controllers/ProductController.php';
        $product = new ProductController();
        $product->bulkDelete();
        break;
        
    case 'products_toggle_best_seller':
        require_once ADMIN_PATH . '/controllers/ProductController.php';
        $product = new ProductController();
        $id = $_GET['id'] ?? 0;
        $product->toggleBestSeller($id);
        break;
        
    // Default route
    default:
        // If user is logged in, redirect to dashboard
        if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
            header('Location: index.php?page=dashboard');
        } else {
            header('Location: index.php?page=login');
        }
        exit;
}

// Helper functions for DashboardController
if (!function_exists('getActivityIcon')) {
    function getActivityIcon($action) {
        $icons = [
            'login' => 'sign-in-alt',
            'logout' => 'sign-out-alt',
            'create' => 'plus',
            'update' => 'edit',
            'delete' => 'trash',
            'view' => 'eye',
            'change_password' => 'key',
            'toggle_best_seller' => 'star'
        ];
        return $icons[$action] ?? 'circle';
    }
}

if (!function_exists('getActivityText')) {
    function getActivityText($action, $description) {
        $actions = [
            'login' => 'logged in',
            'logout' => 'logged out',
            'create' => 'created',
            'update' => 'updated',
            'delete' => 'deleted',
            'view' => 'viewed',
            'change_password' => 'changed password',
            'toggle_best_seller' => 'toggled best seller status'
        ];
        
        $actionText = $actions[$action] ?? $action;
        $desc = $description ? ': ' . $description : '';
        
        return ' ' . $actionText . $desc;
    }
}

if (!function_exists('formatTime')) {
    function formatTime($datetime) {
        $timestamp = strtotime($datetime);
        $now = time();
        $diff = $now - $timestamp;
        
        if ($diff < 60) {
            return 'Just now';
        } elseif ($diff < 3600) {
            return floor($diff / 60) . ' minutes ago';
        } elseif ($diff < 86400) {
            return floor($diff / 3600) . ' hours ago';
        } else {
            return date('d M Y, H:i', $timestamp);
        }
    }
}
?>