# Queen Florist Admin Panel

Backend admin panel lengkap untuk mengelola website Queen Florist dengan fitur CRUD untuk agenda dan produk, dilengkapi dengan sistem authentication yang aman.

## 🌸 Fitur Utama

### 🔐 Authentication & Security
- Login system dengan password terenkripsi (bcrypt)
- Session management yang aman
- Activity logging untuk semua admin actions
- Role-based access control (Admin/Editor)
- Password change functionality
- Auto-logout pada idle

### 📅 Agenda Management
- CRUD lengkap untuk agenda acara
- Search dan filter agenda
- Bulk delete operations
- Date-based organization
- Auto-calculation month/year dari tanggal

### 🛍️ Product Management
- CRUD lengkap untuk produk
- Image upload dengan validasi
- Best seller toggle
- Kategori produk
- Price management
- Bulk operations

### 📊 Dashboard & Analytics
- Real-time statistics
- Recent activities feed
- Upcoming agenda display
- Product overview
- Admin management (super admin only)

### 🎨 Modern UI/UX
- Responsive design (mobile-first)
- Sidebar navigation yang dapat di-collapse
- Dark mode support
- Loading states dan animations
- Form validation real-time
- Auto-save functionality

## 📁 Struktur Folder

```
admin/
├── index.php                    # Main router
├── database/
│   └── queen_florist_complete.sql  # Complete database schema
├── models/
│   ├── AdminModel.php           # Admin authentication & logging
│   ├── AdminAgendaModel.php     # Agenda CRUD operations
│   └── AdminProductModel.php    # Product CRUD operations
├── controllers/
│   ├── AuthController.php       # Authentication logic
│   ├── DashboardController.php  # Dashboard & admin management
│   ├── AgendaController.php     # Agenda CRUD controller
│   └── ProductController.php    # Product CRUD controller
├── views/
│   ├── layout.php               # Main template
│   ├── login.php                # Login page
│   ├── dashboard.php            # Dashboard view
│   ├── agenda/                  # Agenda views
│   │   ├── index.php           # Agenda list
│   │   ├── create.php          # Create agenda
│   │   ├── edit.php            # Edit agenda
│   │   └── view.php            # Agenda details
│   └── products/                # Product views
│       ├── index.php           # Product list
│       ├── create.php          # Create product
│       ├── edit.php            # Edit product
│       └── view.php            # Product details
└── assets/
    ├── css/
    │   └── admin.css           # Complete admin styling
    └── js/
        └── admin.js            # Admin functionality
```

## 🚀 Instalasi & Deployment

### 1. Database Setup
```sql
-- Import database schema
mysql -u username -p database_name < admin/database/queen_florist_complete.sql
```

### 2. Konfigurasi Database
Edit `config/database.php`:
```php
private $host = 'localhost';
private $dbname = 'queen_florist';
private $username = 'your_db_username';
private $password = 'your_db_password';
```

### 3. File Permissions
```bash
# Set permissions untuk upload directory
chmod 755 assets/images/
chmod 644 assets/images/*
chown www-data:www-data assets/images/
```

### 4. Default Login
- **Username:** `admin`
- **Password:** `admin123`

> ⚠️ **PENTING:** Ubah password default setelah login pertama!

## 🔧 Konfigurasi

### PHP Requirements
- PHP 7.4+ atau 8.0+
- MySQL 5.7+ atau MariaDB 10.2+
- GD Extension (untuk image processing)
- File upload enabled

### Server Configuration
```apache
# .htaccess untuk Apache
RewriteEngine On
RewriteCond %{REQUEST_FILENAME} !-f
RewriteCond %{REQUEST_FILENAME} !-d
RewriteRule ^(.*)$ index.php?page=$1 [QSA,L]
```

## 📱 Cara Penggunaan

### 1. Login
Akses `http://domain.com/admin/` dan login dengan kredensial default.

### 2. Dashboard
- View real-time statistics
- Monitor recent activities
- Quick access to all features

### 3. Agenda Management
- **Tambah Agenda:** Klik "Tambah Agenda" → Isi form → Save
- **Edit Agenda:** Klik icon edit pada agenda list
- **Hapus Agenda:** Klik icon delete (dengan konfirmasi)
- **Bulk Delete:** Pilih multiple agenda → Hapus dipilih

### 4. Product Management
- **Tambah Produk:** Klik "Tambah Produk" → Upload gambar → Isi form → Save
- **Edit Produk:** Klik icon edit pada product list
- **Image Upload:** Drag & drop atau click to browse
- **Best Seller:** Toggle status best seller pada product detail

### 5. Admin Management (Super Admin Only)
- **Create Admin:** Dashboard → Admin → Tambah admin baru
- **Manage Roles:** Set admin/editor permissions
- **Activity Logs:** Monitor semua admin activities

## 🛡️ Security Features

### Authentication Security
- Password hashing dengan bcrypt
- Session timeout management
- CSRF protection
- SQL injection prevention
- XSS protection

### File Upload Security
- File type validation
- File size limits (5MB)
- Secure file naming
- Upload directory protection

### Activity Logging
- All CRUD operations logged
- IP address tracking
- User agent logging
- Timestamp records

## 🎨 Customization

### Branding
Edit colors di `assets/css/admin.css`:
```css
:root {
    --primary-color: #3b82f6;
    --secondary-color: #64748b;
    /* ... */
}
```

### Logo & Favicon
Ganti logo di `views/layout.php`:
```php
<span class="logo-icon">🌸</span>
<span class="logo-text">Queen Florist</span>
```

### Custom Fields
Tambah fields di database tables dan update corresponding models/views.

## 🔍 Troubleshooting

### Common Issues

#### 1. Database Connection Error
```php
// Check database credentials in config/database.php
// Verify database exists and user has permissions
```

#### 2. File Upload Not Working
```bash
# Check permissions
ls -la assets/images/
# Set correct ownership
chown www-data:www-data assets/images/
```

#### 3. Session Issues
```php
// Check session.save_path in php.ini
// Verify write permissions
```

#### 4. Blank Pages
```php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);
```

## 📈 Performance Optimization

### Database Optimization
- Indexes untuk frequently queried columns
- Stored procedures untuk complex operations
- View untuk statistics queries

### Caching
- Browser caching untuk static assets
- OPcache untuk PHP performance
- Database query caching

### Image Optimization
- Automatic image resizing
- WebP format support
- Lazy loading untuk product images

## 🔄 Backup & Maintenance

### Database Backup
```bash
# Daily backup
mysqldump -u username -p queen_florist > backup_$(date +%Y%m%d).sql
```

### File Backup
```bash
# Backup assets and config
tar -czf admin_backup_$(date +%Y%m%d).tar.gz admin/
```

### Regular Maintenance
- Clear activity logs (monthly)
- Optimize database tables
- Update PHP dependencies
- Monitor disk space

## 🆘 Support & Documentation

### Help Resources
- Inline help text pada forms
- Tooltips untuk icons
- Error messages yang jelas
- Activity log untuk debugging

### Best Practices
- Regular password changes
- Daily backups
- Monitor admin activities
- Keep software updated

## 📄 License

This project is proprietary to Queen Florist. All rights reserved.

---

**Developed with ❤️ for Queen Florist Indonesia**
*Professional Admin Panel for Flower Shop Management*