# 🌸 Queen Florist - PHP MVC Version

Landing page profesional untuk Queen Florist dengan arsitektur MVC (Model-View-Controller) yang siap di deploy ke CPanel hosting.

## 📋 Fitur Lengkap

### ✨ **Fitur Utama:**
- 📱 **Responsive Design** - Tampilan sempurna di mobile & desktop
- 🎨 **Modern UI** - Desain elegan dengan animasi smooth
- 💬 **WhatsApp Integration** - Order langsung via WhatsApp
- 📅 **Dynamic Agenda** - Menampilkan agenda bulan ini otomatis
- 🛍️ **10 Kategori Produk** - Lengkap dengan foto dan deskripsi
- ⭐ **Customer Testimonials** - Testimoni pelanggan yang puas
- 🎯 **SEO Friendly** - Optimized untuk search engines

### 🏗️ **Arsitektur MVC:**
- **Model** - `models/` (ProductModel, AgendaModel, TestimonialModel)
- **View** - `views/` (index.php, template files)
- **Controller** - `controllers/` (ProductController, AgendaController, TestimonialController)
- **Config** - `config/` (database configuration)

## 📁 Struktur Folder

```
queen-florist-php/
├── index.php                 # Halaman utama (View)
├── config/
│   └── database.php         # Konfigurasi database
├── models/
│   ├── ProductModel.php     # Model produk
│   ├── AgendaModel.php      # Model agenda
│   └── TestimonialModel.php # Model testimonial
├── controllers/
│   ├── ProductController.php     # Controller produk
│   ├── AgendaController.php      # Controller agenda
│   └── TestimonialController.php # Controller testimonial
├── assets/
│   ├── css/
│   │   └── style.css       # Stylesheet lengkap
│   ├── js/
│   │   └── script.js       # JavaScript interaktif
│   └── images/             # Folder gambar
├── queen_florist_database.sql # Database schema & data
└── README.md               # Dokumentasi ini
```

## 🚀 Cara Deploy ke CPanel

### **1. Upload Files**
1. Login ke CPanel hosting Anda
2. Buka **File Manager**
3. Masuk ke folder `public_html`
4. Upload semua file dari folder `queen-florist-php`

### **2. Setup Database**
1. Buka **MySQL Database Wizard** di CPanel
2. Buat database baru: `queen_florist`
3. Buat database user: `queen_florist_user`
4. Grant all privileges ke user
5. Buka **phpMyAdmin**
6. Import file `queen_florist_database.sql`

### **3. Konfigurasi Database**
Edit file `config/database.php`:
```php
private $host = 'localhost';
private $username = 'queen_florist_user';  // Ganti dengan user Anda
private $password = 'password_anda';       // Ganti dengan password Anda
private $database = 'queen_florist';
```

### **4. Set Permissions**
- Folder permissions: `755`
- File permissions: `644`

### **5. Test Website**
Buka website Anda: `https://domain-anda.com`

## 🔧 Konfigurasi Tambahan

### **PHP Requirements**
- PHP 7.4+ (recommended 8.0+)
- MySQL 5.7+ atau MariaDB 10.2+
- Extension: `mysqli`, `mbstring`

### **WhatsApp Integration**
Ubah nomor WhatsApp di `index.php`:
```php
// Ganti dengan nomor WhatsApp Anda
$whatsappNumber = '+6281223968122';
```

### **Customization**
- **Logo**: Ganti icon di `assets/css/style.css`
- **Warna**: Edit CSS variables di `assets/css/style.css`
- **Kontak**: Update informasi di `index.php`

## 📱 Fitur WhatsApp Order

### **Cara Kerja:**
1. User klik **"Order Sekarang"** pada produk
2. Muncul modal form dengan foto produk
3. User isi form (nama, catatan, alamat)
4. Klik **"Kirim ke WhatsApp"**
5. Pesan terbuka dengan format lengkap:
   - Detail produk + link foto
   - Data pemesan lengkap
   - Informasi kontak

### **Format Pesan WhatsApp:**
```
🌸 PESANAN BARU - QUEEN FLORIST 🌸

📋 Detail Produk:
• Nama Produk: Standing Flower
• Kategori: standing flower
• Lihat Foto: https://i.imgur.com/fRauqUO.jpeg

👤 Data Pemesan:
• Nama: John Doe
• Catatan: Untuk anniversary
• Alamat Kirim: Jl. Contoh No.123

📱 Cara Order:
1. Admin akan menghubungi Anda
2. Pembayaran via Transfer/E-Wallet
3. Pengiriman sesuai alamat

📞 Hubungi Kami:
• WhatsApp: +6281223968122
• Instagram: @queen_florist.kebumen
```

## 🎨 Sections Website

### **1. Header**
- Logo Queen Florist 👑
- Navigation menu (smooth scroll)
- WhatsApp chat button

### **2. Hero Section**
- Background image: `https://i.imgur.com/dtZPmsz.jpeg`
- Headline: "Temukan Bunga Terindah untuk Setiap Momen"
- CTA buttons: Lihat Produk, Chat Admin

### **3. Agenda Section**
- Current month agenda (auto-update)
- 4 agenda items untuk Oktober 2025:
  - 24 Oktober - Hari Dokter Indonesia
  - 27 Oktober - Hari Penerbangan Nasional
  - 28 Oktober - Hari Sumpah Pemuda
  - 30 Oktober - Hari Keuangan

### **4. Products Section**
- 10 kategori produk:
  1. Standing Flower 🌹
  2. Paper Flower 🌸
  3. Duka Cita 🕊️
  4. Bouquet 💐
  5. Wedding Car Decoration 🚗
  6. Balloon Decoration 🎈
  7. Kado Rustic 🎁
  8. Balloon Parcel 📦
  9. Snack Bouquet 🍿
  10. Tart Snack 🧁

### **5. Testimonials**
- 3 customer reviews
- 5-star ratings
- Responsive grid layout

### **6. Contact Section**
- Alamat lengkap
- Nomor telepon
- Social media links (Instagram, TikTok)

### **7. Footer**
- Copyright information
- Company details

## 🛠️ Maintenance

### **Update Products**
Edit langsung di database atau tambahkan admin panel.

### **Update Agenda**
Agenda otomatis menampilkan bulan berjalan.

### **Backup Database**
```sql
-- Backup command via cPanel atau phpMyAdmin
mysqldump -u username -p queen_florist > backup.sql
```

## 📞 Kontak Information

- **WhatsApp**: +6281223968122
- **Instagram**: @queen_florist.kebumen
- **TikTok**: @queenflorist
- **Alamat**: Gg. Kutilang No.7, RT.03/RW.03, Panjer, Kec. Kebumen, Kabupaten Kebumen, Jawa Tengah 54312

## 🎄 Performance Optimization

### **Caching**
- Browser caching via .htaccess
- Image optimization
- Minified CSS & JS

### **SEO Meta Tags**
```html
<meta name="description" content="Queen Florist - Pilihan bunga segar dan berkualitas">
<meta name="keywords" content="florist, bunga, bouquet, standing flower">
```

## 🔒 Security

### **Best Practices**
- Input sanitization di semua forms
- SQL injection prevention
- XSS protection
- HTTPS ready

## 📈 Analytics

### **Google Analytics**
Tambahkan sebelum `</head>` di `index.php`:
```html
<!-- Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=GA_MEASUREMENT_ID"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());
  gtag('config', 'GA_MEASUREMENT_ID');
</script>
```

## 🆘 Troubleshooting

### **Common Issues:**
1. **Database Connection Error**
   - Check database credentials
   - Verify database exists
   - Check user permissions

2. **White Screen**
   - Check PHP error logs
   - Verify file permissions
   - Check PHP version

3. **Images Not Loading**
   - Check image URLs
   - Verify file paths
   - Check internet connection

### **Error Logging**
Add to `index.php` for debugging:
```php
error_reporting(E_ALL);
ini_set('display_errors', 1);
```

## 📄 License

© 2025 Queen Florist | brainmultimedia All rights reserved.

---

**Built with ❤️ using PHP MVC Architecture**  
*Ready for production deployment on CPanel hosting*