# 🚀 Queen Florist - Deployment Guide CPanel

Panduan lengkap deploy website Queen Florist ke hosting CPanel.

## 📋 Prasyarat

### **Hosting Requirements:**
- CPanel hosting (shared, VPS, atau dedicated)
- PHP 7.4+ (recommended 8.0+)
- MySQL 5.7+ atau MariaDB 10.2+
- Minimal 100MB storage space
- SSL certificate (recommended)

### **Tools Needed:**
- CPanel login credentials
- File Manager access
- phpMyAdmin access
- FTP client (optional)

## 🔥 Step-by-Step Deployment

### **STEP 1: Upload Files**

#### **Method A: CPanel File Manager**
1. Login ke CPanel: `https://domain-anda.com:2083`
2. Buka **File Manager**
3. Masuk ke folder `public_html`
4. Klik **Upload**
5. Upload file ZIP `queen-florist-php.zip`
6. Klik kanan → **Extract**
7. Rename folder menjadi `queen-florist` (optional)

#### **Method B: FTP Client**
1. Gunakan FileZilla atau FTP client lain
2. Connect ke hosting Anda
3. Masuk ke folder `public_html`
4. Upload semua file dari folder `queen-florist-php`

### **STEP 2: Create Database**

1. Di CPanel, buka **MySQL Database Wizard**
2. **Step 1: Create Database**
   - Database name: `queen_florist`
   - Klik **Next Step**
3. **Step 2: Create Database User**
   - Username: `queen_florist_user`
   - Password: buat password yang kuat
   - Klik **Create User**
4. **Step 3: Add User to Database**
   - Pilih user dan database
   - Check **ALL PRIVILEGES**
   - Klik **Next Step**
   - Klik **Return to Home**

### **STEP 3: Import Database**

1. Buka **phpMyAdmin** di CPanel
2. Pilih database `queen_florist` dari dropdown
3. Klik tab **Import**
4. Choose file: `queen_florist_database.sql`
5. Klik **Go**
6. Tunggu hingga import selesai

### **STEP 4: Configure Database Connection**

#### **Method A: Web Setup (Recommended)**
1. Buka browser: `https://domain-anda.com/deploy.php`
2. Isi form database:
   - Host: `localhost`
   - Username: `queen_florist_user`
   - Password: password yang Anda buat
   - Database: `queen_florist`
3. Klik **Test Connection & Save Config**
4. Jika berhasil, akan redirect ke homepage

#### **Method B: Manual Edit**
1. Buka **File Manager**
2. Edit file `config/database.php`
3. Update konfigurasi:
```php
private $host = 'localhost';
private $username = 'queen_florist_user';
private $password = 'your_password_here';
private $database = 'queen_florist';
```
4. Save file

### **STEP 5: Set File Permissions**

1. Di **File Manager**, select semua files
2. Klik kanan → **Change Permissions**
3. Set permissions:
   - Directories: `755`
   - Files: `644`
4. Klik **Change Permissions**

### **STEP 6: Test Website**

1. Buka browser: `https://domain-anda.com`
2. Website harus tampil dengan sempurna
3. Test semua fitur:
   - Navigation smooth scroll
   - Product order modal
   - WhatsApp integration
   - Responsive design

## 🔧 Konfigurasi Tambahan

### **Enable HTTPS (SSL)**
1. Di CPanel, buka **SSL/TLS Status**
2. Pilih domain Anda
3. Klik **Run AutoSSL**
4. Force HTTPS dengan menambahkan ke `.htaccess`:
```apache
RewriteCond %{HTTPS} off
RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]
```

### **Optimize Performance**
1. Buka **Select PHP Version**
2. Enable extensions:
   - `mysqli`
   - `mbstring`
   - `opcache` (recommended)
3. Set PHP memory: `128M` atau lebih

### **Email Configuration**
1. Buka **Email Accounts**
2. Buat email: `info@domain-anda.com`
3. Update contact information di `index.php`

## 🎨 Customization

### **Update Contact Information**
Edit file `index.php`:
```php
// Update nomor WhatsApp
$whatsappNumber = '+6281223968122';

// Update alamat
$address = 'Gg. Kutilang No.7, RT.03/RW.03, Panjer, Kec. Kebumen, Kabupaten Kebumen, Jawa Tengah 54312';

// Update social media
$instagram = 'https://www.instagram.com/queen_florist.kebumen/';
$tiktok = 'https://www.tiktok.com/@queenflorist';
```

### **Change Colors**
Edit file `assets/css/style.css`:
```css
:root {
    --primary-color: #ec4899;    /* Pink */
    --secondary-color: #25d366;  /* WhatsApp Green */
    --text-color: #1f2937;       /* Dark Gray */
    --bg-color: #ffffff;         /* White */
}
```

### **Update Logo**
Ganti icon logo di `assets/css/style.css`:
```css
.logo-icon::before {
    content: "👑"; /* Ganti dengan emoji atau upload logo image */
}
```

## 📱 Mobile Optimization

### **Test on Mobile**
1. Buka website di smartphone
2. Test responsive design
3. Test WhatsApp order functionality
4. Test loading speed

### **Optimize Images**
1. Compress images sebelum upload
2. Use WebP format jika supported
3. Add lazy loading untuk images

## 🔒 Security Hardening

### **Basic Security**
1. Update file permissions:
   - Sensitive files: `600`
   - Config files: `644`
2. Protect config directory:
   ```apache
   <Files "config/database.php">
       Order allow,deny
       Deny from all
   </Files>
   ```

### **Advanced Security**
1. Enable Cloudflare (jika available)
2. Set up firewall rules
3. Regular backups
4. Monitor error logs

## 📊 Monitoring & Analytics

### **Google Analytics**
1. Sign up ke Google Analytics
2. Get tracking ID
3. Add to `index.php` sebelum `</head>`:
```html
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=GA_MEASUREMENT_ID"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());
  gtag('config', 'GA_MEASUREMENT_ID');
</script>
```

### **Facebook Pixel**
```html
<!-- Facebook Pixel Code -->
<script>
!function(f,b,e,v,n,t,s)
{if(f.fbq)return;n=f.fbq=function(){n.callMethod?
n.callMethod.apply(n,arguments):n.queue.push(arguments)};
if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
n.queue=[];t=b.createElement(e);t.async=!0;
t.src=v;s=b.getElementsByTagName(e)[0];
s.parentNode.insertBefore(t,s)}(window, document,'script',
'https://connect.facebook.net/en_US/fbevents.js');
fbq('init', 'YOUR_PIXEL_ID');
fbq('track', 'PageView');
</script>
<noscript><img height="1" width="1" style="display:none"
src="https://www.facebook.com/tr?id=YOUR_PIXEL_ID&ev=PageView&noscript=1"
/></noscript>
```

## 🚨 Troubleshooting

### **Common Issues & Solutions**

#### **1. White Screen/Blank Page**
**Causes:**
- PHP syntax error
- Memory limit exceeded
- File permissions issue

**Solutions:**
```php
// Add to index.php for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);
```

#### **2. Database Connection Error**
**Causes:**
- Wrong database credentials
- Database doesn't exist
- User permissions issue

**Solutions:**
1. Check database credentials in `config/database.php`
2. Verify database exists in phpMyAdmin
3. Check user has proper privileges

#### **3. Images Not Loading**
**Causes:**
- Wrong file paths
- Hotlink protection
- File permissions

**Solutions:**
1. Check image URLs in database
2. Verify files exist in `assets/images/`
3. Check file permissions (644)

#### **4. WhatsApp Not Working**
**Causes:**
- Wrong phone number format
- JavaScript error
- Popup blocked

**Solutions:**
1. Use format: `+6281223968122`
2. Check browser console for errors
3. Allow popups for your domain

#### **5. CSS/JS Not Loading**
**Causes:**
- Wrong file paths
- Server configuration
- Cache issue

**Solutions:**
1. Clear browser cache
2. Check file paths in `index.php`
3. Verify `.htaccess` configuration

### **Error Logs Location**
- CPanel: **Metrics → Errors**
- Custom path: `/home/username/logs/error_log`
- PHP errors: Check in cPanel PHP error log

## 🔄 Maintenance

### **Regular Tasks**
1. **Weekly:**
   - Check error logs
   - Monitor website uptime
   - Test contact forms

2. **Monthly:**
   - Update PHP version if needed
   - Backup database
   - Check SSL certificate

3. **Quarterly:**
   - Review analytics
   - Update content
   - Security audit

### **Backup Strategy**
1. **Database Backup:**
   ```sql
   -- Via phpMyAdmin: Export database
   -- Via command line:
   mysqldump -u username -p queen_florist > backup.sql
   ```

2. **File Backup:**
   - Download all files via FTP
   - Use CPanel backup tool
   - Store backup offsite

## 📞 Support

### **Getting Help**
1. **CPanel Support:** Contact hosting provider
2. **Documentation:** Check `README.md`
3. **Community:** PHP/MySQL forums

### **Useful Links**
- [CPanel Documentation](https://docs.cpanel.net/)
- [PHP Manual](https://www.php.net/docs.php)
- [MySQL Documentation](https://dev.mysql.com/doc/)

---

## ✅ Deployment Checklist

- [ ] Upload all files to `public_html`
- [ ] Create database `queen_florist`
- [ ] Create database user with privileges
- [ ] Import `queen_florist_database.sql`
- [ ] Configure `config/database.php`
- [ ] Set file permissions (755/644)
- [ ] Test website functionality
- [ ] Test WhatsApp order feature
- [ ] Test mobile responsiveness
- [ ] Enable SSL/HTTPS
- [ ] Set up analytics
- [ ] Create backup schedule

**🎉 Selamat! Website Queen Florist Anda sudah live!**

---

*Last updated: January 2025*  
*Version: 1.0 - PHP MVC Architecture*