// Data Produk
const products = [
    {
        id: 'standing-flower',
        name: 'Standing Flower',
        category: 'standing flower',
        image: 'http://info.queenflorist.art/assets/standing%20flower%20best.jpg',
        icon: 'fa-spa'
    },
    {
        id: 'paper-flower',
        name: 'Paper Flower',
        category: 'paper flower',
        image: 'http://info.queenflorist.art/assets/paper%20flower.jpg',
        icon: 'fa-spa'
    },
    {
        id: 'duka-cita',
        name: 'Bunga Duka Cita',
        category: 'duka cita',
        image: 'http://info.queenflorist.art/assets/duka%20cita.jpg',
        icon: 'fa-spa'
    },
    {
        id: 'bouquet',
        name: 'Bouquet',
        category: 'bouquet',
        image: 'http://info.queenflorist.art/assets/bouquet.jpg',
        icon: 'fa-spa'
    },
    {
        id: 'wedding-car',
        name: 'Wedding Car Decoration',
        category: 'wedding car decoration',
        image: 'http://info.queenflorist.art/assets/wedcar.jpeg',
        icon: 'fa-car'
    },
    {
        id: 'balloon-decoration',
        name: 'Balloon Decoration',
        category: 'balloon decoration',
        image: 'http://info.queenflorist.art/assets/balon%20decoration.jpg',
        icon: 'fa-heart'
    },
    {
        id: 'kado-rustic',
        name: 'Kado Rustic',
        category: 'kado rustic',
        image: 'http://info.queenflorist.art/assets/kadorustic.jpeg',
        icon: 'fa-gift'
    },
    {
        id: 'balloon-parcel',
        name: 'Balloon Parcel',
        category: 'ballon parcel',
        image: 'http://info.queenflorist.art/assets/ballon%20parcel.jpg',
        icon: 'fa-box'
    },
    {
        id: 'snack-bouquet',
        name: 'Snack Bouquet',
        category: 'snack bouquet',
        image: 'http://info.queenflorist.art/assets/snack%20bouquet.jpg',
        icon: 'fa-cookie'
    },
    {
        id: 'tart-snack',
        name: 'Tart Snack',
        category: 'tart snack',
        image: 'http://info.queenflorist.art/assets/tart%20snack.jpg',
        icon: 'fa-birthday-cake'
    }
];

// Data Agenda
const agendaData = {
    'JANUARI': [
        { date: 1, month: 'Januari', description: 'HUT SMKN 2 Kebumen' },
        { date: 10, month: 'Januari', description: 'Hari Lingkungan Hidup Indonesia' },
        { date: 10, month: 'Januari', description: 'Hari Gerakan Satu Juta Pohon' },
        { date: 13, month: 'Januari', description: 'Hari HAM Nelayan dan Masyarakat Sipil' },
        { date: 15, month: 'Januari', description: 'Hari Dharma Samudera' },
        { date: 22, month: 'Januari', description: 'Hari Pejalan Kaki Nasional' },
        { date: 23, month: 'Januari', description: 'Hari Proklamasi Gorontalo' },
        { date: 24, month: 'Januari', description: 'Hari Jadi Pemalang' },
        { date: 25, month: 'Januari', description: 'Hari Gizi dan Makanan' },
        { date: 30, month: 'Januari', description: 'Hari Primata Indonesia' },
        { date: 31, month: 'Januari', description: 'Hari Lahir Nahdlatul Ulama' }
    ],
    'FEBRUARI': [
        { date: 1, month: 'Februari', description: 'HUT SMP Negeri 1 Kebumen' },
        { date: 5, month: 'Februari', description: 'Hari Lahir Himpunan Mahasiswa Islam (HMI)' },
        { date: 5, month: 'Februari', description: 'Hari Peristiwa Kapal Tujuh Provinsi' },
        { date: 9, month: 'Februari', description: 'Hari Persatuan Wartawan Indonesia (PWI)' },
        { date: 9, month: 'Februari', description: 'Hari Pers Nasional' },
        { date: 13, month: 'Februari', description: 'Hari Persatuan Farmasi Indonesia' },
        { date: 14, month: 'Februari', description: 'Hari Peringatan Pemberontakan Pembela Tanah Air (PETA)' },
        { date: 17, month: 'Februari', description: 'HUT SMP Negeri 1 Adimulyo' },
        { date: 17, month: 'Februari', description: 'HUT SMP Negeri 4 Kebumen' },
        { date: 19, month: 'Februari', description: 'Hari Komando Pertahanan Udara Nasional (Kohadnudnas)' },
        { date: 20, month: 'Februari', description: 'Hari Pekerja Nasional' },
        { date: 21, month: 'Februari', description: 'Hari Peduli Sampah Nasional' },
        { date: 21, month: 'Februari', description: 'HUT SDIT Ibnu Abbas Kebumen' },
        { date: 22, month: 'Februari', description: 'Hari Istiqlal' },
        { date: 28, month: 'Februari', description: 'Hari Gizi Nasional Indonesia' }
    ],
    'MARET': [
        { date: 1, month: 'Maret', description: 'Peristiwa Serangan Umum 1 Maret 1949' },
        { date: 1, month: 'Maret', description: 'Hari Penegakan Kedaulatan Negara' },
        { date: 1, month: 'Maret', description: 'Hari Kehakiman Nasional' },
        { date: 2, month: 'Maret', description: 'HUT SMK Maarif 3 Kebumen' },
        { date: 3, month: 'Maret', description: 'Hari Dewan Kerajinan Indonesia (DEKRANAS)' },
        { date: 5, month: 'Maret', description: 'Hari Konvensi CITES (Perdagangan Satwa Liar)' },
        { date: 6, month: 'Maret', description: 'Hari KOSTRAD (Komando Cadangan Strategis Angkatan Darat)' },
        { date: 9, month: 'Maret', description: 'Hari Wanita Indonesia' },
        { date: 9, month: 'Maret', description: 'Hari Musik Nasional' },
        { date: 10, month: 'Maret', description: 'Hari Persatuan Artis Film Indonesia (PARFI)' },
        { date: 11, month: 'Maret', description: 'Hari Surat Perintah 11 Maret (Supersemar)' },
        { date: 14, month: 'Maret', description: 'HUT SMK Maarif 1 Kebumen' },
        { date: 17, month: 'Maret', description: 'Hari Perawat Nasional' },
        { date: 17, month: 'Maret', description: 'HUT SMK Negeri 1 Karanggayam Kebumen' },
        { date: 18, month: 'Maret', description: 'Hari Arsitektur Indonesia' },
        { date: 24, month: 'Maret', description: 'Hari Peringatan Bandung Lautan Api' },
        { date: 30, month: 'Maret', description: 'Hari Film Nasional' },
        { date: 30, month: 'Maret', description: 'HUT SMP Negeri 5 Kebumen' }
    ],
    'APRIL': [
        { date: 1, month: 'April', description: 'Hari Penyiaran Nasional' },
        { date: 2, month: 'April', description: 'HUT SMK Negeri 1 Gombong Kebumen' },
        { date: 3, month: 'April', description: 'HUT SMK Maarif 6 Ayah Kebumen' },
        { date: 4, month: 'April', description: 'Hari Lahir Persandian Nasional' },
        { date: 6, month: 'April', description: 'Hari Nelayan Indonesia' },
        { date: 9, month: 'April', description: 'Hari Ulang Tahun (HUT) TNI Angkatan Udara' },
        { date: 11, month: 'April', description: 'Hari Kanker Tulang Nasional' },
        { date: 11, month: 'April', description: 'HUT SMK Maarif 8 Gombong Kebumen' },
        { date: 13, month: 'April', description: 'HUT SMK Maarif 9 Klirong Kebumen' },
        { date: 16, month: 'April', description: 'Hari Komando Pasukan Khusus (Kopassus)' },
        { date: 18, month: 'April', description: 'Hari Peringatan Konferensi Asia-Afrika (KAA) di Bandung' },
        { date: 19, month: 'April', description: 'Hari Pertahanan Sipil (Hansip)' },
        { date: 20, month: 'April', description: 'Hari Konsumen Nasional' },
        { date: 21, month: 'April', description: 'Hari Kartini' },
        { date: 22, month: 'April', description: 'Hari Bumi' },
        { date: 24, month: 'April', description: 'Hari Angkutan Nasional' },
        { date: 25, month: 'April', description: 'Hari Otonomi Daerah' },
        { date: 26, month: 'April', description: 'Hari Kesiapsiagaan Bencana' },
        { date: 27, month: 'April', description: 'Hari Bhakti Pemasyarakatan (HBP)' },
        { date: 28, month: 'April', description: 'Hari Puisi Nasional' },
        { date: 29, month: 'April', description: 'Hari Posyandu Nasional' }
    ],
    'MEI': [
        { date: 1, month: 'Mei', description: 'Hari Peringatan Pembebasan Irian Barat' },
        { date: 2, month: 'Mei', description: 'Hari Pendidikan Nasional (Hardiknas)' },
        { date: 5, month: 'Mei', description: 'Hari Lembaga Sosial Desa (LSD)' },
        { date: 5, month: 'Mei', description: 'HUT SMA Negeri 1 Pejagoan' },
        { date: 7, month: 'Mei', description: 'Hari Perjanjian Roem Royen' },
        { date: 7, month: 'Mei', description: 'HUT SDIT Al Madinah Kebumen' },
        { date: 9, month: 'Mei', description: 'HUT SMK Maarif 2 Gombong Kebumen' },
        { date: 10, month: 'Mei', description: 'HUT SMK TKM PERTAMBANGAN KEBUMEN' },
        { date: 11, month: 'Mei', description: 'Hari Polisi Militer Tentara Nasional Indonesia (POM TNI)' },
        { date: 17, month: 'Mei', description: 'Hari Buku Nasional' },
        { date: 17, month: 'Mei', description: 'Hari Ulang Tahun Perpustakaan Nasional RI (HUT Perpusnas)' },
        { date: 17, month: 'Mei', description: 'HUT SMK Ma\'arif 5 Gombong Kebumen' },
        { date: 17, month: 'Mei', description: 'HUT SMK Ma\'arif 7 Kutowinangun Kebumen' },
        { date: 19, month: 'Mei', description: 'Hari Korps Cacat Veteran Indonesia' },
        { date: 20, month: 'Mei', description: 'Hari Kebangkitan Nasional (Harkitnas)' },
        { date: 20, month: 'Mei', description: 'HUT SMK Maarif 4 Kebumen' },
        { date: 21, month: 'Mei', description: 'Hari Peringatan Reformasi' },
        { date: 23, month: 'Mei', description: 'HUT SMP Negeri 7 Kebumen' },
        { date: 25, month: 'Mei', description: 'HUT SMK Nawa Bhakti Kebumen' },
        { date: 27, month: 'Mei', description: 'Hari Jamu Nasional' },
        { date: 29, month: 'Mei', description: 'Hari Lanjut Usia Nasional (HLUN/Hari Lansia Nasional)' }
    ],
    'JUNI': [
        { date: 1, month: 'Juni', description: 'Hari Lahir Pancasila' },
        { date: 3, month: 'Juni', description: 'Hari Pasar Modal Indonesia' },
        { date: 10, month: 'Juni', description: 'Hari Media Sosial Indonesia' },
        { date: 17, month: 'Juni', description: 'Hari Dermaga Nasional' },
        { date: 21, month: 'Juni', description: 'Hari Krida Pertanian' },
        { date: 21, month: 'Juni', description: 'HUT SLB Negeri Tamanwinangun Kebumen' },
        { date: 22, month: 'Juni', description: 'Hari Ulang Tahun Jakarta' },
        { date: 24, month: 'Juni', description: 'Hari Bidan Nasional' },
        { date: 29, month: 'Juni', description: 'Hari Keluarga Nasional' }
    ],
    'JULI': [
        { date: 1, month: 'Juli', description: 'Hari Bhayangkara' },
        { date: 1, month: 'Juli', description: 'HUT SD Islam Ulil Albab Kebumen' },
        { date: 5, month: 'Juli', description: 'Hari Bank Indonesia' },
        { date: 7, month: 'Juli', description: 'Hari Pustakawan' },
        { date: 12, month: 'Juli', description: 'Hari Koperasi Indonesia' },
        { date: 17, month: 'Juli', description: 'Hari Integrasi Timor Timur' },
        { date: 22, month: 'Juli', description: 'Hari Kejaksaan' },
        { date: 23, month: 'Juli', description: 'Hari Anak Nasional' },
        { date: 23, month: 'Juli', description: 'Hari Tanpa Televisi' },
        { date: 29, month: 'Juli', description: 'Hari Bhakti TNI Angkatan Udara' },
        { date: 30, month: 'Juli', description: 'Hari Ikrar Gerakan Pramuka' }
    ],
    'AGUSTUS': [
        { date: 1, month: 'Agustus', description: 'HUT SMA Negeri 1 Kebumen' },
        { date: 1, month: 'Agustus', description: 'HUT SMP Negeri 2 Kebumen' },
        { date: 1, month: 'Agustus', description: 'HUT SMP Negeri 3 Kebumen' },
        { date: 5, month: 'Agustus', description: 'Hari Dharma Wanita Nasional' },
        { date: 7, month: 'Agustus', description: 'Hari Hutan Indonesia' },
        { date: 10, month: 'Agustus', description: 'Hari Veteran Nasional, Hari Kebangkitan Teknologi Nasional' },
        { date: 13, month: 'Agustus', description: 'HUT Mahkamah Konstitusi' },
        { date: 14, month: 'Agustus', description: 'Hari Pramuka (Praja Muda Karana)' },
        { date: 17, month: 'Agustus', description: 'Hari Proklamasi Kemerdekaan Indonesia/HUT RI' },
        { date: 18, month: 'Agustus', description: 'Hari Konstitusi Republik Indonesia' },
        { date: 19, month: 'Agustus', description: 'Hari Departemen Luar Negeri Indonesia, HUT Mahkamah Agung' },
        { date: 21, month: 'Agustus', description: 'Hari Maritim Nasional' },
        { date: 21, month: 'Agustus', description: 'Hari Jadi Kabupaten Kebumen' },
        { date: 23, month: 'Agustus', description: 'Hari Peringatan Konferensi Meja Bundar' },
        { date: 24, month: 'Agustus', description: 'Hari Ulang Tahun TVRI, Hari Jakarta Membaca' },
        { date: 25, month: 'Agustus', description: 'Hari Perumahan Nasional (Hapernas)' }
    ],
    'SEPTEMBER': [
        { date: 1, month: 'September', description: 'SMK BINA KARYA 1 Karanganyar Kebumen' },
        { date: 1, month: 'September', description: 'Hari Polisi Wanita (POLWAN)' },
        { date: 3, month: 'September', description: 'Hari Palang Merah Indonesia' },
        { date: 4, month: 'September', description: 'Hari Pelanggan Nasional' },
        { date: 8, month: 'September', description: 'Hari Pamong Praja' },
        { date: 9, month: 'September', description: 'Hari Ulang Tahun Partai Demokrat' },
        { date: 9, month: 'September', description: 'Hari Olahraga Nasional' },
        { date: 11, month: 'September', description: 'Hari Radio Republik Indonesia' },
        { date: 14, month: 'September', description: 'Hari Kunjung Perpustakaan' },
        { date: 17, month: 'September', description: 'Hari Perhubungan Nasional' },
        { date: 17, month: 'September', description: 'Hari Palang Merah Nasional' },
        { date: 22, month: 'September', description: 'Hari Bebas Kendaraan Bermotor' },
        { date: 24, month: 'September', description: 'Hari Tani' },
        { date: 27, month: 'September', description: 'Hari Bakti Pos dan Telekomunikasi' },
        { date: 27, month: 'September', description: 'Hari Pos Telekomunikasi Telegraf (PTT)' },
        { date: 28, month: 'September', description: 'Hari Kereta Api' },
        { date: 29, month: 'September', description: 'Hari Sarjana Indonesia' },
        { date: 30, month: 'September', description: 'Hari Peringatan Pemberontakan G30S/PKI' }
    ],
    'OKTOBER': [
        { date: 1, month: 'Oktober', description: 'Hari Kesaktian Pancasila' },
        { date: 1, month: 'Oktober', description: 'HUT SMA Negeri 2 Kebumen' },
        { date: 2, month: 'Oktober', description: 'Hari Batik Nasional' },
        { date: 2, month: 'Oktober', description: 'HUT SMK Taman Karya Madya Teknik Kebumen' },
        { date: 5, month: 'Oktober', description: 'Hari Tentara Nasional Indonesia (TNI)' },
        { date: 8, month: 'Oktober', description: 'Hari Tata Ruang Nasional' },
        { date: 9, month: 'Oktober', description: 'HUT SMAN 1 Prembun' },
        { date: 12, month: 'Oktober', description: 'Hari Museum Nasional' },
        { date: 14, month: 'Oktober', description: 'Hari Tilem' },
        { date: 16, month: 'Oktober', description: 'Hari Parlemen Indonesia' },
        { date: 21, month: 'Oktober', description: 'Hari Ulang Tahun Golongan Karya' },
        { date: 22, month: 'Oktober', description: 'Hari Santri Nasional' },
        { date: 24, month: 'Oktober', description: 'Hari Dokter Indonesia' },
        { date: 27, month: 'Oktober', description: 'Hari Penerbangan Nasional, Hari Listrik Nasional, dan Hari Narablog Nasional' },
        { date: 28, month: 'Oktober', description: 'Hari Sumpah Pemuda' },
        { date: 30, month: 'Oktober', description: 'Hari Keuangan Nasional' }
    ],
    'NOVEMBER': [
        { date: 3, month: 'November', description: 'Hari Kerohanian' },
        { date: 3, month: 'November', description: 'Hari Cinta Puspa dan Satwa Nasional' },
        { date: 10, month: 'November', description: 'Hari Pahlawan' },
        { date: 10, month: 'November', description: 'Hari Ganefo' },
        { date: 10, month: 'November', description: 'HUT SMAN 1 KUTOWINANGUN' },
        { date: 11, month: 'November', description: 'Hari Bangunan Indonesia' },
        { date: 12, month: 'November', description: 'Hari Kesehatan Nasional' },
        { date: 12, month: 'November', description: 'Hari Ayah Nasional' },
        { date: 14, month: 'November', description: 'Hari Brigade Mobil (BRIMOB)' },
        { date: 22, month: 'November', description: 'Hari Perhubungan Darat Nasional' },
        { date: 25, month: 'November', description: 'Hari Guru (PGRI)' },
        { date: 28, month: 'November', description: 'Hari Menanam Pohon Indonesia' },
        { date: 29, month: 'November', description: 'Hari KORPRI (Korps Pegawai Republik Indonesia)' }
    ],
    'DESEMBER': [
        { date: 1, month: 'Desember', description: 'Hari AIDS Sedunia, Hari Artileri' },
        { date: 3, month: 'Desember', description: 'Hari Disabilitas Internasional, Hari Bakti Pekerjaan Umum' },
        { date: 9, month: 'Desember', description: 'Hari Armada Republik Indonesia' },
        { date: 10, month: 'Desember', description: 'Hari Hak Asasi Manusia' },
        { date: 11, month: 'Desember', description: 'HUT SMP Negeri 6 Kebumen' },
        { date: 12, month: 'Desember', description: 'Hari Transmigrasi' },
        { date: 13, month: 'Desember', description: 'Hari Nusantara' },
        { date: 15, month: 'Desember', description: 'Hari Juang Kartika TNI-AD' },
        { date: 19, month: 'Desember', description: 'Hari Bela Negara' },
        { date: 19, month: 'Desember', description: 'Hari Trikora' },
        { date: 20, month: 'Desember', description: 'Hari Kesetiakawanan Sosial Nasional' },
        { date: 22, month: 'Desember', description: 'Hari Ibu' },
        { date: 25, month: 'Desember', description: 'Hari Natal' }
    ]
};

// DOM Elements
const navToggle = document.getElementById('nav-toggle');
const navMenu = document.getElementById('nav-menu');
const modal = document.getElementById('order-modal');
const modalClose = document.getElementById('modal-close');
const modalProductName = document.getElementById('modal-product-name');
const modalProductImage = document.getElementById('modal-product-image');
const orderForm = document.getElementById('order-form');
const currentMonthSpan = document.getElementById('current-month');
const agendaList = document.getElementById('agenda-list');
const produkGrid = document.getElementById('produk-grid');

let currentProduct = null;

// Initialize
document.addEventListener('DOMContentLoaded', function() {
    initializeApp();
});

function initializeApp() {
    setupEventListeners();
    loadCurrentMonth();
    loadAgenda();
    loadProducts();
    setupSmoothScroll();
    setupNavbarScroll();
}

// Event Listeners
function setupEventListeners() {
    // Mobile menu toggle
    navToggle.addEventListener('click', function() {
        navMenu.classList.toggle('active');
        const icon = navToggle.querySelector('i');
        icon.classList.toggle('fa-bars');
        icon.classList.toggle('fa-times');
    });

    // Close mobile menu when clicking on a link
    document.querySelectorAll('.nav-link').forEach(link => {
        link.addEventListener('click', function() {
            navMenu.classList.remove('active');
            const icon = navToggle.querySelector('i');
            icon.classList.add('fa-bars');
            icon.classList.remove('fa-times');
        });
    });

    // Modal events
    modalClose.addEventListener('click', closeModal);
    modal.addEventListener('click', function(e) {
        if (e.target === modal) {
            closeModal();
        }
    });

    // Order form submission
    orderForm.addEventListener('submit', handleOrderSubmit);

    // Escape key to close modal
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape' && modal.style.display === 'block') {
            closeModal();
        }
    });
}

// Load current month
function loadCurrentMonth() {
    const now = new Date();
    const months = ['JANUARI', 'FEBRUARI', 'MARET', 'APRIL', 'MEI', 'JUNI', 'JULI', 'AGUSTUS', 'SEPTEMBER', 'OKTOBER', 'NOVEMBER', 'DESEMBER'];
    const currentMonthName = months[now.getMonth()];
    currentMonthSpan.textContent = currentMonthName;
}

// Load agenda
function loadAgenda() {
    const now = new Date();
    const months = ['JANUARI', 'FEBRUARI', 'MARET', 'APRIL', 'MEI', 'JUNI', 'JULI', 'AGUSTUS', 'SEPTEMBER', 'OKTOBER', 'NOVEMBER', 'DESEMBER'];
    const currentMonthName = months[now.getMonth()];
    const currentAgenda = agendaData[currentMonthName] || [];

    agendaList.innerHTML = '';

    currentAgenda.forEach((agenda, index) => {
        const daysUntil = getDaysUntilAgenda(agenda.date, agenda.month);
        const isUpcoming = daysUntil >= 0;

        const agendaItem = document.createElement('div');
        agendaItem.className = `agenda-item ${isUpcoming ? 'upcoming' : ''}`;
        agendaItem.innerHTML = `
            <div class="agenda-left">
                <div class="agenda-date">${agenda.date}</div>
                <div class="agenda-info">
                    <h4>${agenda.description}</h4>
                    <p>${agenda.month}</p>
                </div>
            </div>
            ${isUpcoming ? `<div class="agenda-badge">${daysUntil === 0 ? 'Hari Ini!' : `${daysUntil} hari lagi`}</div>` : ''}
        `;

        agendaList.appendChild(agendaItem);
    });
}

// Load products
function loadProducts() {
    produkGrid.innerHTML = '';

    products.forEach(product => {
        const productCard = document.createElement('div');
        productCard.className = 'produk-card';
        productCard.innerHTML = `
            <div class="produk-image">
                <img src="${product.image}" alt="${product.name}" loading="lazy">
                <div class="produk-icon">
                    <i class="fas ${product.icon}"></i>
                </div>
            </div>
            <div class="produk-content">
                <h3 class="produk-name">${product.name}</h3>
                <button class="btn btn-primary btn-full" onclick="openOrderModal('${product.id}')">
                    <i class="fas fa-shopping-bag"></i>
                    Order Sekarang
                </button>
            </div>
        `;

        produkGrid.appendChild(productCard);
    });
}

// Calculate days until agenda
function getDaysUntilAgenda(agendaDate, agendaMonth) {
    const now = new Date();
    const today = now.getDate();
    const currentMonthIndex = now.getMonth();
    
    const monthIndices = {
        'Januari': 0, 'Februari': 1, 'Maret': 2, 'April': 3, 'Mei': 4, 'Juni': 5,
        'Juli': 6, 'Agustus': 7, 'September': 8, 'Oktober': 9, 'November': 10, 'Desember': 11
    };
    
    const agendaMonthIndex = monthIndices[agendaMonth];
    
    if (agendaMonthIndex === currentMonthIndex) {
        return agendaDate - today;
    } else if (agendaMonthIndex > currentMonthIndex) {
        return agendaDate + (30 * (agendaMonthIndex - currentMonthIndex)) - today;
    } else {
        return agendaDate + (30 * (12 - currentMonthIndex + agendaMonthIndex)) - today;
    }
}

// Open order modal
function openOrderModal(productId) {
    currentProduct = products.find(p => p.id === productId);
    if (!currentProduct) return;

    modalProductName.textContent = currentProduct.name;
    modalProductImage.src = currentProduct.image;
    modalProductImage.alt = currentProduct.name;
    
    // Reset form
    orderForm.reset();
    
    // Show modal
    modal.style.display = 'block';
    document.body.style.overflow = 'hidden';
}

// Close modal
function closeModal() {
    modal.style.display = 'none';
    document.body.style.overflow = 'auto';
    currentProduct = null;
}

// Handle order form submission
function handleOrderSubmit(e) {
    e.preventDefault();
    
    if (!currentProduct) return;

    const formData = new FormData(orderForm);
    const nama = formData.get('nama');
    const catatan = formData.get('catatan');
    const rencana = formData.get('rencana');
    const alamat = formData.get('alamat');

    // Validation
    if (!nama || !catatan || !rencana || !alamat) {
        alert('Mohon lengkapi semua form sebelum mengirim pesan.');
        return;
    }

    // Create WhatsApp message
    const message = `🌸 *QUEEN FLORIST - PESANAN BARU* 🌸

📋 *Detail Pesanan:*
• Produk: ${currentProduct.name}
• Nama: ${nama}
• Catatan: ${catatan}
• Rencana: ${rencana}
• Alamat: ${alamat}

📸 *Lihat produk:*
${currentProduct.image}

Mohon informasikan ketersediaan dan total harga. Terima kasih! 🙏`;

    // Open WhatsApp
    const whatsappUrl = `https://wa.me/6281223968122?text=${encodeURIComponent(message)}`;
    window.open(whatsappUrl, '_blank');

    // Close modal
    closeModal();
}

// Smooth scrolling
function setupSmoothScroll() {
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function(e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                const offsetTop = target.offsetTop - 80; // Account for fixed navbar
                window.scrollTo({
                    top: offsetTop,
                    behavior: 'smooth'
                });
            }
        });
    });
}

// Navbar scroll effect
function setupNavbarScroll() {
    let lastScrollTop = 0;
    const navbar = document.querySelector('.navbar');

    window.addEventListener('scroll', function() {
        const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
        
        if (scrollTop > 100) {
            navbar.style.background = 'rgba(255, 255, 255, 0.98)';
            navbar.style.boxShadow = '0 4px 20px rgba(0, 0, 0, 0.1)';
        } else {
            navbar.style.background = 'rgba(255, 255, 255, 0.95)';
            navbar.style.boxShadow = '0 2px 10px rgba(0, 0, 0, 0.1)';
        }

        lastScrollTop = scrollTop;
    });
}

// Utility functions
function debounce(func, wait) {
    let timeout;
    return function executedFunction(...args) {
        const later = () => {
            clearTimeout(timeout);
            func(...args);
        };
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
    };
}

// Lazy loading for images
function setupLazyLoading() {
    const images = document.querySelectorAll('img[loading="lazy"]');
    
    if ('IntersectionObserver' in window) {
        const imageObserver = new IntersectionObserver((entries, observer) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    const img = entry.target;
                    img.src = img.dataset.src || img.src;
                    img.classList.remove('lazy');
                    imageObserver.unobserve(img);
                }
            });
        });

        images.forEach(img => imageObserver.observe(img));
    }
}

// Initialize lazy loading
setupLazyLoading();