<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Queen Florist - Temukan Bunga Terindah untuk Setiap Momen</title>
    <meta name="description" content="Temukan bunga terindah untuk setiap momen spesial Anda. Standing flower, bouquet, wedding decoration, dan lainnya.">
    <meta name="keywords" content="florist, bunga, wedding, bouquet, standing flower, kebumen">
    <meta name="author" content="Queen Florist">
    
    <!-- Open Graph Meta Tags -->
    <meta property="og:title" content="Queen Florist - Temukan Bunga Terindah untuk Setiap Momen">
    <meta property="og:description" content="Temukan bunga terindah untuk setiap momen spesial Anda">
    <meta property="og:image" content="http://info.queenflorist.art/assets/header.jpg">
    <meta property="og:url" content="http://info.queenflorist.art">
    <meta property="og:type" content="website">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="favicon.ico">
    
    <!-- CSS -->
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="css/responsive.css">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar">
        <div class="container">
            <div class="nav-content">
                <div class="nav-logo">
                    <i class="fas fa-spa"></i>
                    <span>QUEEN Florist</span>
                </div>
                
                <div class="nav-menu" id="nav-menu">
                    <a href="#beranda" class="nav-link">Beranda</a>
                    <a href="#agenda" class="nav-link">Agenda</a>
                    <a href="#produk" class="nav-link">Produk</a>
                    <a href="#kontak" class="nav-link">Kontak</a>
                </div>
                
                <div class="nav-toggle" id="nav-toggle">
                    <i class="fas fa-bars"></i>
                </div>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section id="beranda" class="hero">
        <div class="hero-overlay"></div>
        <div class="container">
            <div class="hero-content">
                <h1 class="hero-title animate-fade-in">
                    Temukan Bunga Terindah untuk Setiap Momen
                </h1>
                <p class="hero-subtitle animate-fade-in-delay">
                    Kualitas premium, desain elegan, dan pelayanan terbaik
                </p>
                
                <div class="hero-buttons animate-fade-in-delay-2">
                    <a href="#produk" class="btn btn-primary">
                        Lihat Produk
                        <i class="fas fa-arrow-right"></i>
                    </a>
                    
                    <a href="https://wa.me/6281223968122?text=Hai kak mimin yang baik hati, bisa diinfokan..." 
                       class="btn btn-secondary" target="_blank">
                        Chat Admin
                        <i class="fas fa-shopping-bag"></i>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Agenda Section -->
    <section id="agenda" class="agenda">
        <div class="container">
            <div class="section-header">
                <h2 class="section-title">Agenda Bulan Ini</h2>
                <p class="section-subtitle">
                    Kalender <span id="current-month"></span> - Acara Spesial Anda
                </p>
            </div>
            
            <div class="agenda-list" id="agenda-list">
                <!-- Agenda items will be loaded by JavaScript -->
            </div>
        </div>
    </section>

    <!-- Produk Section -->
    <section id="produk" class="produk">
        <div class="container">
            <div class="section-header">
                <h2 class="section-title">Produk Unggulan Kami</h2>
                <p class="section-subtitle">
                    Koleksi bunga dan dekorasi terbaik untuk momen spesial Anda
                </p>
            </div>
            
            <div class="produk-grid" id="produk-grid">
                <!-- Products will be loaded by JavaScript -->
            </div>
        </div>
    </section>

    <!-- Testimoni Section -->
    <section class="testimoni">
        <div class="container">
            <div class="section-header">
                <h2 class="section-title">Testimoni Pelanggan</h2>
                <p class="section-subtitle">
                    Apa kata mereka tentang Queen Florist
                </p>
            </div>
            
            <div class="testimoni-grid">
                <div class="testimoni-card">
                    <div class="testimoni-rating">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <p class="testimoni-text">
                        "Bunga sangat segar dan pelayanan ramah. Sangat puas dengan hasilnya!"
                    </p>
                    <p class="testimoni-author">- Siti Nurhaliza</p>
                </div>
                
                <div class="testimoni-card">
                    <div class="testimoni-rating">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <p class="testimoni-text">
                        "Kualitas bunga premium, pengiriman tepat waktu. Recommended!"
                    </p>
                    <p class="testimoni-author">- Budi Santoso</p>
                </div>
                
                <div class="testimoni-card">
                    <div class="testimoni-rating">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <p class="testimoni-text">
                        "Desain bunga sangat cantik dan sesuai dengan keinginan. Terima kasih Queen Florist!"
                    </p>
                    <p class="testimoni-author">- Maya Putri</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer Section -->
    <footer id="kontak" class="footer">
        <div class="container">
            <div class="footer-content">
                <div class="footer-section">
                    <div class="footer-logo">
                        <i class="fas fa-spa"></i>
                        <span>QUEEN Florist</span>
                    </div>
                    <p class="footer-description">
                        Temukan bunga terindah untuk setiap momen spesial dalam hidup Anda.
                    </p>
                    <div class="footer-social">
                        <a href="https://www.instagram.com/queen_florist.kebumen/" target="_blank">
                            <i class="fab fa-instagram"></i>
                        </a>
                        <a href="https://www.tiktok.com/@queenflorist" target="_blank">
                            <i class="fab fa-tiktok"></i>
                        </a>
                    </div>
                </div>
                
                <div class="footer-section">
                    <h3 class="footer-title">Kontak Kami</h3>
                    <div class="footer-info">
                        <div class="footer-info-item">
                            <i class="fas fa-map-marker-alt"></i>
                            <span>Gg. Kutilang No.7, RT.03/RW.03, Panjer, Kec. Kebumen, Kabupaten Kebumen, Jawa Tengah 54312</span>
                        </div>
                        <div class="footer-info-item">
                            <i class="fas fa-phone"></i>
                            <span>+6281223968122</span>
                        </div>
                        <div class="footer-info-item">
                            <i class="fas fa-envelope"></i>
                            <span>info@queenflorist.art</span>
                        </div>
                    </div>
                </div>
                
                <div class="footer-section">
                    <h3 class="footer-title">Lokasi Kami</h3>
                    <div class="footer-map">
                        <iframe
                            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3956.8428775473745!2d109.6588!3d-7.6708!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x2e65a5e5e5e5e5e5%3A0x5e5e5e5e5e5e5e5e!2sQueen%20Florist!5e0!3m2!1sen!2sid!4v1234567890"
                            width="100%"
                            height="200"
                            style="border: 0"
                            allowFullScreen
                            loading="lazy"
                        ></iframe>
                    </div>
                </div>
            </div>
            
            <div class="footer-bottom">
                <p>Copyright © 2025 Queen Florist | brainmultimedia All rights reserved.</p>
            </div>
        </div>
    </footer>

    <!-- Order Modal -->
    <div id="order-modal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title">
                    <i class="fas fa-shopping-bag"></i>
                    Pesan <span id="modal-product-name"></span>
                </h3>
                <span class="modal-close" id="modal-close">&times;</span>
            </div>
            
            <div class="modal-body">
                <div class="modal-image">
                    <img id="modal-product-image" src="" alt="">
                </div>
                
                <form id="order-form" class="order-form">
                    <div class="form-group">
                        <label for="nama">Nama Lengkap *</label>
                        <input type="text" id="nama" name="nama" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="catatan">Catatan Pesanan *</label>
                        <textarea id="catatan" name="catatan" rows="2" required></textarea>
                    </div>
                    
                    <div class="form-group">
                        <label for="rencana">Rencana Ambil/Kirim *</label>
                        <input type="text" id="rencana" name="rencana" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="alamat">Alamat Kirim *</label>
                        <textarea id="alamat" name="alamat" rows="2" required></textarea>
                    </div>
                    
                    <button type="submit" class="btn btn-primary btn-full">
                        <i class="fas fa-whatsapp"></i>
                        Kirim Pesan WhatsApp
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- JavaScript -->
    <script src="js/main.js"></script>
</body>
</html>