# Queen Florist - Landing Page

Landing page yang menarik untuk bisnis florist "Queen Florist" dengan fitur lengkap dan responsif.

## Fitur

### 🌸 **Hero Section**
- Background image yang menarik
- Judul utama "Temukan Bunga Terindah untuk Setiap Momen"
- Tombol CTA (Call to Action) dengan animasi
- Smooth scroll ke section lain

### 📅 **Agenda Section**
- Sistem otomatis berdasarkan timezone Jakarta
- Menampilkan agenda bulan ini dalam bentuk list
- Highlight untuk agenda yang akan datang
- Countdown hari menuju agenda

### 🛍️ **Produk Section**
- 10 kategori produk dengan gambar best seller
- Hover effects dan animasi yang menarik
- Tombol order dengan form WhatsApp

### 📝 **Form Order WhatsApp**
- Form lengkap: Nama, Catatan, Rencana, Alamat
- Validasi form sebelum kirim
- Foto produk otomatis terlampir di WhatsApp
- Responsive untuk mobile

### ⭐ **Testimoni**
- 3 testimoni pelanggan
- Rating bintang dengan animasi

### 📍 **Footer & Kontak**
- Informasi kontak lengkap
- Google Maps embed
- Social media links
- Copyright information

## Teknologi

- **HTML5** - Semantik dan modern
- **CSS3** - Dengan animasi dan responsive design
- **JavaScript** - Vanilla JS untuk interaktivitas
- **Font Awesome** - Icons
- **Google Fonts** - Typography

## Cara Install di cPanel

1. **Upload folder** `queen-florist-deploy` ke dalam folder `public_html` atau subdomain Anda melalui:
   - cPanel File Manager
   - FTP Client (FileZilla, dll)
   - cPanel File Upload

2. **Set permissions** (jika diperlukan):
   - Folder: 755
   - File: 644

3. **Akses website**:
   - Jika di `public_html`: `http://domainanda.com`
   - Jika di subfolder: `http://domainanda.com/queen-florist-deploy`

## Struktur Folder

```
queen-florist-deploy/
├── index.php              # File utama
├── css/
│   ├── style.css          # Styles utama
│   └── responsive.css     # Styles responsif
├── js/
│   └── main.js            # JavaScript utama
└── README.md              # Dokumentasi
```

## Kustomisasi

### Mengubah Informasi Kontak
Edit file `index.php` di bagian footer:
```html
<div class="footer-info-item">
    <i class="fas fa-phone"></i>
    <span>+6281223968122</span>
</div>
```

### Mengubah Produk
Edit file `js/main.js` di array `products`:
```javascript
{
    id: 'produk-id',
    name: 'Nama Produk',
    category: 'kategori',
    image: 'url-gambar',
    icon: 'fa-icon'
}
```

### Mengubah Agenda
Edit file `js/main.js` di object `agendaData`:
```javascript
'JANUARI': [
    { date: 1, month: 'Januari', description: 'Nama Agenda' }
]
```

### Mengubah Warna Theme
Edit file `css/style.css` dan ubah variabel warna:
```css
:root {
    --primary-color: #ec4899;
    --secondary-color: #10b981;
}
```

## Browser Support

- Chrome 60+
- Firefox 55+
- Safari 12+
- Edge 79+
- Mobile Browsers

## SEO Optimized

- Meta tags lengkap
- Open Graph tags
- Semantic HTML5
- Alt text untuk gambar
- Responsive design

## Performance

- Lazy loading untuk gambar
- Minified CSS dan JS
- Optimized animations
- Fast loading

## Support

Jika ada pertanyaan atau kendala, hubungi:
- WhatsApp: +6281223968122
- Email: info@queenflorist.art

---
Copyright © 2025 Queen Florist | brainmultimedia All rights reserved.